﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using AutoMapper;
using HIPS.Web.Model;
using HIPS.Web.Model.Hpii;
using HIPS.Web.UI.Helpers.Mapping.Context;
using HIPS.Web.UI.ViewModels.HpiiSearch;

namespace HIPS.Web.UI.Helpers.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for the Local Provider.
    /// </summary>
    internal class LocalProviderProfile : Profile
    {
        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }
        
        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            this.CreateMap<LocalProvider, LocalProviderViewModel>()
                .ForMember(dest => dest.FullName, opt => opt.MapFrom(src => string.Format("{0} {1} {2} {3}", src.Title, src.GivenNames, src.FamilyName, src.Suffix).Trim()))                
                .ForMember(dest => dest.Hpii, opt => opt.MapFrom(src => src.Hpii))
                .ForMember(dest => dest.HpiiStatus, opt => opt.MapFrom(src => src.HpiiStatus))
                .ForMember(dest => dest.Active, opt => opt.MapFrom(src => src.Active))
                .ForMember(dest => dest.LocalProviderCode, opt => opt.MapFrom(src => src.LocalProviderCode))
                .ForMember(dest => dest.LocalIdentifier, opt => opt.ResolveUsing<LocalIdentifierResolver>().FromMember(src => src.LocalProviderIdentifiers));
        }

        /// <summary>
        /// Resolves the value of Local Identifier.
        /// </summary>
        internal class LocalIdentifierResolver : IValueResolver
        {
            /// <summary>
            /// Resolve the required value.
            /// </summary>
            /// <param name="source">ResolutionResult representing the source.</param>
            /// <returns>ResolutionResult representing the destination.</returns>
            public ResolutionResult Resolve(ResolutionResult source)
            {
                if (source == null)
                {
                    throw new ArgumentNullException("source");
                }

                var context = source.Context.Options.Items.Values.OfType<LocalProviderMappingContext>().SingleOrDefault();

                var localProviderIdentifiers = source.Value as List<LocalProviderIdentifier>;
                var result = localProviderIdentifiers.Where(lpi => lpi.HospitalCode == context.HospitalCode && lpi.HospitalCodeSystem == context.HospitalCodeSystem)
                                                     .FirstOrDefault();
                if (result != null)
                {
                    return source.New(result.PasProviderIdentifier);
                }

                return source.New(null);
            }
        }
    }
}
