﻿#region Using Statements

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.Schemas.Enumerators;

using HIPS.Web.ModelInterface;
using HIPS.Web.UI.Helpers;

#endregion

namespace HIPS.Web.UI.Helpers
{
    /// <summary>
    /// Represents the result of a check for PCEHR access.
    /// </summary>
    public class PcehrAccessResult
    {
        #region Properties

        /// <summary>
        /// Gets or sets a value that indicates if access to the PCEHR is allowed.
        /// </summary>
        public bool AccessAllowed { get; private set; }

        /// <summary>
        /// Gets or sets a message providing further information on PCEHR access.
        /// </summary>
        public string AccessMessage { get; private set; }

        /// <summary>
        /// Gets a value indicating whether if the patient is valid.
        /// </summary>
        public bool PatientValid { get; private set; }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="accessAllowed">A value that indicates if access to the PCEHR is allowed</param>
        /// <param name="accessMessage">A message providing further information on PCEHR access.</param>
        /// <param name="patientValid">A value that indicates if the patient is valid</param>
        public PcehrAccessResult(bool accessAllowed, string accessMessage, bool patientValid)
        {
            this.AccessAllowed = accessAllowed;
            this.AccessMessage = accessMessage;
            this.PatientValid = patientValid;
        }

        #endregion Constructors
    }

}