﻿using HIPS.Web.Model.Common;
using HIPS.Web.ModelInterface.Common;

namespace HIPS.Web.UI.Helpers
{
    /// <summary>
    /// Manages session-based configuration data.
    /// </summary>
    public class SessionConfiguration : ISessionConfiguration
    {
        #region Constants

        /// <summary>
        /// Session key used to get/set the representing hospital.
        /// </summary>
        private const string SESSION_KEY_REPRESENTING_HOSPITAL = "nehta.hips.ui.web/common/representing_hospital";

        #endregion Constants

        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="SessionConfiguration" /> class.
        /// </summary>
        /// <param name="sessionProvider">The session provider used by the class.</param>
        public SessionConfiguration(ISessionProvider sessionProvider)
        {
            this.SessionProvider = sessionProvider;
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the hospital the individual is representing during the session.
        /// </summary>
        public Hospital RepresentingHospital
        {
            get
            {
                return this.SessionProvider.Get(SESSION_KEY_REPRESENTING_HOSPITAL) as Hospital;
            }
            set
            {
                this.SessionProvider.Set(SESSION_KEY_REPRESENTING_HOSPITAL, value);
            }
        }

        /// <summary>
        /// Gets or sets the session provider used by the class.
        /// </summary>
        private ISessionProvider SessionProvider { get; set; }

        #endregion Properties
    }
}