﻿using HIPS.Web.Components.Common;
using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.Helpers
{
    /// <summary>
    /// Provides extension methods related to working with view models.
    /// </summary>
    public static class ViewModelExtensions
    {
        #region Methods

        /// <summary>
        /// Gets the CSS class used to display an alert for a view message.
        /// </summary>
        /// <param name="message">ViewMessage to display the alert for.</param>
        /// <returns>String containing the CSS class.</returns>
        public static string GetAlertCssClass(this ViewMessage message)
        {
            string result = string.Empty;

            switch (message.Level)
            {
                case (MessageLevel.Information):
                    {
                        result = "alert-info";
                        break;
                    }
                case (MessageLevel.Warning):
                    {
                        result = "alert-warning";
                        break;
                    }
                case (MessageLevel.Error):
                    {
                        result = "alert-danger";
                        break;
                    }
            }

            return result;
        }

        /// <summary>
        /// Gets the CSS class used to display an icon for a view message.
        /// </summary>
        /// <param name="message">ViewMessage to display the alert for.</param>
        /// <returns>String containing the CSS class.</returns>
        public static string GetIconCssClass(this ViewMessage message)
        {
            string result = string.Empty;

            switch (message.Level)
            {
                case (MessageLevel.Information):
                    {
                        result = "glyphicon-info-sign";
                        break;
                    }
                case (MessageLevel.Warning):
                    {
                        result = "glyphicon-question-sign";
                        break;
                    }
                case (MessageLevel.Error):
                    {
                        result = "glyphicon-warning-sign";
                        break;
                    }
            }

            return result;
        }

        #endregion Methods
    }
}