﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;

namespace HIPS.Web.UI.ViewModels.DocumentUpload
{
    /// <summary>
    /// View model for selecting a hospital and displaying its current patients.
    /// </summary>
    public class PatientsViewModel : DocumentUploadViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="PatientsViewModel" /> class.
        /// </summary>
        public PatientsViewModel()
        {
            this.Hospitals = Enumerable.Empty<SelectListItem>();
            this.Patients = new List<PatientViewModel>();
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets the list of patients for a selected hospital.
        /// </summary>
        public List<PatientViewModel> Patients { get; internal set; }

        /// <summary>
        /// Gets the list of hospitals available for selection.
        /// </summary>
        public IEnumerable<SelectListItem> Hospitals { get; internal set; }

        /// <summary>
        /// Gets or sets the MRN entered by the user to look up a patient.
        /// </summary>
        [Required]
        [Display(Name = "Lookup by MRN:")]
        public string LookupMrn { get; set; }

        #endregion Properties
    }
}