﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.ViewModels.HpiiSearch
{
    public class AddEditResultViewModel : LocalProviderViewModelBase
    {
        /// <summary>
        /// Gets or sets Selected Title Id.
        /// </summary>
        [Display(Name = "Title")]
        public string Title { get; set; }

        /// <summary>
        /// Gets or sets Selected Suffix Id.
        /// </summary>
        [Display(Name = "Suffix")]
        public string Suffix { get; set; }

        /// <summary>
        /// Gets or sets Family Name.
        /// </summary>
        [Display(Name = "Family Name")]
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets Given Name.
        /// </summary>
        [Display(Name = "Given Name")]
        public string GivenName { get; set; }

        /// <summary>
        /// Gets or sets Hpii.
        /// </summary>
        [Display(Name = "HPI-I")]
        public string Hpii { get; set; }

        /// <summary>
        /// Gets or sets Hpii status
        /// </summary>
        [Display(Name = "HPI-I Status")]
        public string HpiiStatus { get; set; }

        /// <summary>
        /// Gets or sets Local Provider Identifier.
        /// </summary>
        [Display(Name = "Local Identifier")]
        public string LocalProviderIdentifier { get; set; }

        /// <summary>
        /// Gets or sets response messages
        /// </summary>
        public ResponseMessages ResponseMessages { get; internal set; }

        public AddEditResultViewModel()
        {
            ResponseMessages = new ResponseMessages();
        }
    }
}