using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;

namespace HIPS.Web.UI.ViewModels.HpiiSearch
{
    public class InternationalAddressViewModel
    {
        [Display(Name = "Address Line")]
        [StringLength(120, ErrorMessage = "International Address Line must be less than 120 characters long.")]
        public string InternationalAddressLine { get; set; }

        [Display(Name = "State / Province")]
        [StringLength(40, ErrorMessage = "International State / Province must be less than 120 characters long.")]
        public string InternationalStateProvince { get; set; }

        [Display(Name = "Postcode")]
        [StringLength(10, ErrorMessage = "International Postcode must be less than 10 characters long.")]
        public string InternationalPostcode { get; set; }

        [Display(Name = "Country")]
        public string CountryCode { get; set; }

        #region Data Source Properties

        public IEnumerable<SelectListItem> Countries { get; internal set; }

        #endregion Data Source Properties

        public InternationalAddressViewModel()
        {
            Countries = Enumerable.Empty<SelectListItem>();
        }

        public bool HasAnyValue()
        {
            return new[] {
                InternationalAddressLine,
                InternationalStateProvince,
                InternationalPostcode,
                InternationalStateProvince
            }.Any(s => !String.IsNullOrEmpty(s));
        }
    }
}