﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.ViewModels.HpiiSearch
{
    /// <summary>
    /// Base view model to be used with the local providers feature.
    /// </summary>
    public class LocalProviderViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="LocalProviderViewModelBase" /> class.
        /// </summary>
        public LocalProviderViewModelBase()
        {
            this.Messages = new ViewMessageList();
        }

        #endregion
        
        #region Properties
        
        /// <summary>
        /// Gets or sets the list of messages associated with the view model.
        /// </summary>
        public ViewMessageList Messages { get; set; }
     
        /// <summary>
        /// Gets or sets the currently selected hospital.
        /// </summary>
        public HospitalViewModel CurrentHospital { get; set; }

        #endregion
    }
}
