/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.constant.DateParsePatterns;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateUtils {
    private static final int MIN_TIMEZONE_APPLICATION = 8;
    private static final int MIN_HALF_HOUR_APPLICATION = 10;
    private static final int MAX_PRECISION = 14;
    private static final int SMALL_TIMEZONE_PRECISION = 2;
    private static final int LARGE_TIMEZONE_PRECISION = 4;
    private static final int HALF_HOUR = 30;
    private static final int YEAR_PRECISION = 4;
    private static final int MONTH_PRECISION = 2;
    private static final int DAY_PRECISION = 2;
    private static final int HOUR_PRECISION = 2;
    private static final int MINUTE_PRECISION = 2;
    private static final int SECOND_PRECISION = 2;

    private DateUtils() {
    }

    public static Timestamp generateTimestamp() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date());
        Timestamp timestamp = new Timestamp();
        try {
            timestamp.setCreated(DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar));
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException("Unexpected exception has occurred.", e);
        }
        return timestamp;
    }

    public static XMLGregorianCalendar getXMLGregorianCalendar(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException("Unexpected exception has occurred.", e);
        }
    }

    public static String toUtcDate(String dateTime) {
        Validate.notNull((Object)dateTime, (String)"'dateTime' must be specified.");
        String[] dateTimeComponents = dateTime.split("[+|-]");
        if (dateTimeComponents != null && dateTimeComponents.length > 0) {
            DateParsePatterns dateParsePattern = DateParsePatterns.findByMatchPatternLength(dateTimeComponents[0]);
            DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)dateParsePattern.getPatternValue());
            LocalDateTime localTime = dateTimeFormatter.parseDateTime(dateTimeComponents[0]).toLocalDateTime();
            if (dateTimeComponents.length == 1) {
                return DateUtils.outputPrecision(localTime.toDateTime(), dateParsePattern.getMatchPatternLength(), false);
            }
            if (dateTimeComponents.length == 2) {
                if (dateTimeComponents[0].length() <= 8) {
                    return DateUtils.outputPrecision(localTime.toDateTime(), dateParsePattern.getMatchPatternLength(), false);
                }
                String operator = null;
                operator = dateTime.contains("-") ? "-" : "";
                Holder halfHour = new Holder();
                DateTimeZone timeZone = DateUtils.findTimeZonePatternByLength(operator, dateTimeComponents[1], (Holder<Boolean>)halfHour);
                DateTime srcDateTime = localTime.toDateTime(timeZone);
                DateTime dstDateTime = srcDateTime.withZone(DateTimeZone.UTC);
                return DateUtils.outputPrecision(dstDateTime, dateParsePattern.getMatchPatternLength(), (Boolean)halfHour.value);
            }
            throw new IllegalStateException("Unexpected exception has occurred.");
        }
        throw new IllegalArgumentException("Unable to extract date/time components.");
    }

    private static DateTimeZone findTimeZonePatternByLength(String operator, String timeZone, Holder<Boolean> halfHour) {
        Validate.notEmpty((String)"'operator' must be specified.");
        Validate.notEmpty((String)"'timeZone' must be specified.");
        halfHour.value = false;
        if (timeZone.length() == 2) {
            return DateTimeZone.forOffsetHours((int)Integer.parseInt(String.format("%s%s", operator, timeZone)));
        }
        if (timeZone.length() == 4) {
            int mid = timeZone.length() / 2;
            int hoursOffset = Integer.parseInt(String.format("%s%s", operator, timeZone.substring(0, mid)));
            int minsOffset = Integer.parseInt(timeZone.substring(mid, timeZone.length()));
            if (minsOffset / 30 == 1) {
                halfHour.value = true;
            }
            return DateTimeZone.forOffsetHoursMinutes((int)hoursOffset, (int)minsOffset);
        }
        throw new IllegalArgumentException("'dateTime' does not match an expected pattern length.");
    }

    private static String outputPrecision(DateTime dateTime, int precision, boolean halfHour) {
        Validate.notNull((Object)dateTime, (String)"'dateTime' must be specified.");
        Validate.notNull((Object)precision, (String)"''precision' must be specified.");
        Validate.notNull((Object)precision, (String)"''halfHour' must be specified.");
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.leftPad((String)String.valueOf(dateTime.getYear()), (int)4, (String)"0"));
        sb.append(StringUtils.leftPad((String)String.valueOf(dateTime.getMonthOfYear()), (int)2, (String)"0"));
        sb.append(StringUtils.leftPad((String)String.valueOf(dateTime.getDayOfMonth()), (int)2, (String)"0"));
        sb.append(StringUtils.leftPad((String)String.valueOf(dateTime.getHourOfDay()), (int)2, (String)"0"));
        sb.append(StringUtils.leftPad((String)String.valueOf(dateTime.getMinuteOfHour()), (int)2, (String)"0"));
        sb.append(StringUtils.leftPad((String)String.valueOf(dateTime.getSecondOfMinute()), (int)2, (String)"0"));
        if (precision > 14) {
            return sb.toString().substring(0, 14);
        }
        if (precision == 10 && halfHour) {
            return sb.toString().substring(0, precision + 2);
        }
        return sb.toString().substring(0, precision);
    }
}

