/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class HandlerUtils {
    private HandlerUtils() {
    }

    public static Element getFirstElementFromNodeList(NodeList nodeList) {
        Validate.notNull((Object)nodeList, (String)"'nodeList' cannot be null.");
        Element element = null;
        if (nodeList.getLength() > 0) {
            Validate.notNull((Object)nodeList.item(0), (String)"'nodeList.item' cannot be null.");
            element = (Element)nodeList.item(0);
        }
        return element;
    }

    public static boolean isResponseType(SOAPMessageContext context, String namespace, String localName) {
        Validate.notNull((Object)context, (String)"SOAPMessageContext cannot be null");
        boolean result = false;
        try {
            SOAPEnvelope envelope = context.getMessage().getSOAPPart().getEnvelope();
            SOAPBody body = envelope.getBody();
            NodeList responseType = body.getElementsByTagNameNS(namespace, localName);
            if (responseType.getLength() > 0) {
                result = true;
            }
        }
        catch (SOAPException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return result;
    }

    public static Boolean isOutgoing(SOAPMessageContext context) {
        return (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
    }

    public static String extractElementContent(SOAPBody body, String namespace, String localName) {
        NodeList nodeList = body.getElementsByTagNameNS(namespace, localName);
        Element documentElement = HandlerUtils.getFirstElementFromNodeList(nodeList);
        if (documentElement != null && documentElement.getFirstChild() != null) {
            return documentElement.getFirstChild().getNodeValue();
        }
        return null;
    }
}

