/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.datatypes;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.mdm.enums.CodingSystem;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidation;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class CE {
    private static final int CE_COMPONENT_COUNT = 3;
    private final String identifier;
    private final String text;
    private final CodingSystem codingSystem;

    private CE(Builder builder) {
        this.identifier = builder.identifier;
        this.text = builder.text;
        this.codingSystem = builder.codingSystem;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getText() {
        return this.text;
    }

    public CodingSystem getCodingSystem() {
        return this.codingSystem;
    }

    public static CE parse(String parseValue) {
        ArgumentUtils.checkNotNull((Object)parseValue, (String)"parseValue");
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(parseValue.split("\\^")));
        while (values.size() < 3) {
            values.add("");
        }
        if (values.size() == 3) {
            try {
                return new Builder().identifier((String)values.get(0)).text((String)values.get(1)).codingSystem(CodingSystem.valueOf((String)values.get(2))).build();
            }
            catch (MDMValidationException e) {
                throw new IllegalArgumentException("Unable to parse CE", e);
            }
        }
        throw new IllegalArgumentException("Unable to parse CE - Invalid number of value components:\n\tActual: " + values.size() + "\n\tExpected: " + 3);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.identifier);
        sb.append("^");
        sb.append(this.text);
        sb.append("^");
        sb.append((Object)this.codingSystem);
        return sb.toString().replaceAll(String.format("\\%s*$", "^"), "");
    }

    public static final class Builder {
        private String identifier = "";
        private String text = "";
        private CodingSystem codingSystem;

        public Builder identifier(String value) {
            this.identifier = value;
            return this;
        }

        public Builder text(String value) {
            this.text = value;
            return this;
        }

        public Builder codingSystem(CodingSystem value) {
            this.codingSystem = value;
            return this;
        }

        public CE build() throws MDMValidationException {
            HashMap<String, List<String>> failedVariables = new HashMap<String, List<String>>();
            failedVariables.putAll(MDMValidation.confirmNotNull("identifier", this.identifier, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("text", this.text, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("codingSystem", this.identifier, true));
            if (!failedVariables.isEmpty()) {
                throw new MDMValidationException("Failed to build CE", failedVariables);
            }
            return new CE(this);
        }
    }
}

