/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.datatypes;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.mdm.datatypes.HD;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidation;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class XCN {
    private static final int XCN_COMPONENT_COUNT = 13;
    private final String identifier;
    private final String familyName;
    private final String givenName;
    private final String middleInitialOrName;
    private final String suffix;
    private final String prefix;
    private final HD assigningAuthority;
    private final String identifierTypeCode;

    private XCN(Builder builder) {
        this.identifier = builder.identifier;
        this.familyName = builder.familyName;
        this.givenName = builder.givenName;
        this.middleInitialOrName = builder.middleInitialOrName;
        this.suffix = builder.suffix;
        this.prefix = builder.prefix;
        this.assigningAuthority = builder.assigningAuthority;
        this.identifierTypeCode = builder.identifierTypeCode;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getMiddleInitialOrName() {
        return this.middleInitialOrName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public HD getAssigningAuthority() {
        return this.assigningAuthority;
    }

    public String getIdentifierTypeCode() {
        return this.identifierTypeCode;
    }

    public static XCN parse(String parseValue) {
        ArgumentUtils.checkNotNull((Object)parseValue, (String)"parseValue");
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(parseValue.split("\\^")));
        while (values.size() < 13) {
            values.add("");
        }
        if (values.size() == 13) {
            try {
                return new Builder().identifier((String)values.get(0)).familyName((String)values.get(1)).givenName((String)values.get(2)).middleInitialOrName((String)values.get(3)).suffix((String)values.get(4)).prefix((String)values.get(5)).assigningAuthority(HD.parse((String)values.get(8))).identifierTypeCode((String)values.get(12)).build();
            }
            catch (MDMValidationException e) {
                throw new IllegalArgumentException("Unable to parse XCN", e);
            }
        }
        throw new IllegalArgumentException("Unable to parse XCN - Invalid number of value components:\n\tActual: " + values.size() + "\n\tExpected: " + 13);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.identifier);
        sb.append("^");
        sb.append(this.familyName);
        sb.append("^");
        sb.append(this.givenName);
        sb.append("^");
        sb.append(this.middleInitialOrName);
        sb.append("^");
        sb.append(this.suffix);
        sb.append("^");
        sb.append(this.prefix);
        sb.append("^");
        sb.append("^");
        sb.append("^");
        sb.append(this.assigningAuthority.toString());
        sb.append("^");
        sb.append("^");
        sb.append("^");
        sb.append("^");
        sb.append(this.identifierTypeCode);
        return sb.toString().replaceAll(String.format("\\%s*$", "^"), "");
    }

    public static final class Builder {
        private String identifier = "";
        private String familyName = "";
        private String givenName = "";
        private String middleInitialOrName = "";
        private String suffix = "";
        private String prefix = "";
        private HD assigningAuthority;
        private String identifierTypeCode = "";

        public Builder identifier(String value) {
            this.identifier = value;
            return this;
        }

        public Builder familyName(String value) {
            this.familyName = value;
            return this;
        }

        public Builder givenName(String value) {
            this.givenName = value;
            return this;
        }

        public Builder middleInitialOrName(String value) {
            this.middleInitialOrName = value;
            return this;
        }

        public Builder suffix(String value) {
            this.suffix = value;
            return this;
        }

        public Builder prefix(String value) {
            this.prefix = value;
            return this;
        }

        public Builder assigningAuthority(HD value) {
            this.assigningAuthority = value;
            return this;
        }

        public Builder identifierTypeCode(String value) {
            this.identifierTypeCode = value;
            return this;
        }

        public XCN build() throws MDMValidationException {
            HashMap<String, List<String>> failedVariables = new HashMap<String, List<String>>();
            failedVariables.putAll(MDMValidation.confirmNotNull("identifier", this.identifier, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("familyName", this.familyName, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("givenName", this.givenName, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("middleInitialOrName", this.middleInitialOrName, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("suffix", this.suffix, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("prefix", this.prefix, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("assigningAuthority", this.assigningAuthority, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("identifierTypeCode", this.identifierTypeCode, true));
            if (!failedVariables.isEmpty()) {
                throw new MDMValidationException("Invalid XCN", failedVariables);
            }
            return new XCN(this);
        }
    }
}

