/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.segments;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidation;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidationException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public final class EVN {
    private static final String EVN_SEGMENT_NAME = "EVN";
    private static final int EVN_FIELD_COUNT = 3;
    private static final String EVN_DATE_TIME_PATTERN = "yyyyMMddHHmmss";
    private static final String EVENT_TYPE_CODE = "T02";
    private final Date recordedDateTime;

    private EVN(Builder builder) {
        this.recordedDateTime = builder.recordedDateTime;
    }

    public String getEventTypeCode() {
        return EVENT_TYPE_CODE;
    }

    public Date getRecordedDateTime() {
        return this.recordedDateTime;
    }

    public static EVN parse(String parseValue) {
        ArgumentUtils.checkNotNull((Object)parseValue, (String)"parseValue");
        List<String> fields = Arrays.asList(parseValue.split("\\|"));
        if (fields.size() >= 3) {
            if (fields.get(0).compareTo(EVN_SEGMENT_NAME) != 0) {
                throw new IllegalArgumentException(String.format("Unable to parse EVN - Segment name is incorrect: \n\tActual Value: %s\n\tExpected Value: %s", fields.get(0), EVN_SEGMENT_NAME));
            }
            try {
                return new Builder().recordedDateTime(new SimpleDateFormat(EVN_DATE_TIME_PATTERN).parse(fields.get(2))).build();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Unable to parse EVN - Invalid date/time pattern supplied:\n\tActual Value: %s\n\tExpected Format: %s", fields.get(2), EVN_DATE_TIME_PATTERN));
            }
            catch (MDMValidationException e) {
                throw new IllegalArgumentException("Unable to parse EVN", e);
            }
        }
        throw new IllegalArgumentException(String.format("Unable to parse EVN - Invalid number of fields:\n\tActual: %d\n\tExpected: %d", fields.size(), 3));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EVN_SEGMENT_NAME);
        sb.append("|");
        sb.append(EVENT_TYPE_CODE);
        sb.append("|");
        sb.append(new SimpleDateFormat(EVN_DATE_TIME_PATTERN).format(this.recordedDateTime));
        sb.append("\r");
        return sb.toString();
    }

    public static final class Builder {
        private Date recordedDateTime;

        public Builder recordedDateTime(Date value) {
            this.recordedDateTime = value;
            return this;
        }

        public EVN build() throws MDMValidationException {
            HashMap<String, List<String>> failedVariables = new HashMap<String, List<String>>();
            failedVariables.putAll(MDMValidation.confirmNotNull("recordedDateTime", this.recordedDateTime, true));
            if (!failedVariables.isEmpty()) {
                throw new MDMValidationException("Invalid EVN segment", failedVariables);
            }
            return new EVN(this);
        }
    }
}

