/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.segments;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.mdm.datatypes.HD;
import au.gov.nehta.vendorlibrary.mdm.enums.AcknowledgementType;
import au.gov.nehta.vendorlibrary.mdm.enums.CountryCode;
import au.gov.nehta.vendorlibrary.mdm.enums.ProcessingId;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidation;
import au.gov.nehta.vendorlibrary.mdm.util.MDMValidationException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public final class MSH {
    private static final String MSH_SEGMENT_NAME = "MSH";
    private static final int MSH_FIELD_COUNT = 17;
    private static final String MSH_DATE_TIME_PATTERN = "yyyyMMddHHmmssZ";
    private static final String MSH_LENIENT_DATE_TIME_PATTERN = "yyyyMMddHHmmss";
    private static final String ENCODING_CHARACTERS = "^~\\&";
    private final HD sendingApplication;
    private final HD sendingFacility;
    private final HD receivingApplication;
    private final HD receivingFacility;
    private final Date messageDateTime;
    private static final String MESSAGE_TYPE = "MDM^T02^MDM_T02";
    private final String messageControlId;
    private static final ProcessingId PROCESSING_ID = ProcessingId.P;
    private static final String VERSION_ID = "2.3.1";
    private static final AcknowledgementType ACCEPT_ACKNOWLEDGEMENT_TYPE = AcknowledgementType.NE;
    private static final AcknowledgementType APPLICATION_ACKNOWLEDGEMENT_TYPE = AcknowledgementType.AL;
    private static final CountryCode COUNTRY_CODE = CountryCode.AUSTRALIA;

    private MSH(Builder builder) {
        this.sendingApplication = builder.sendingApplication;
        this.sendingFacility = builder.sendingFacility;
        this.receivingApplication = builder.receivingApplication;
        this.receivingFacility = builder.receivingFacility;
        this.messageDateTime = builder.messageDateTime;
        this.messageControlId = builder.messageControlId;
    }

    public String getEncodingCharacters() {
        return ENCODING_CHARACTERS;
    }

    public HD getSendingApplication() {
        return this.sendingApplication;
    }

    public HD getSendingFacility() {
        return this.sendingFacility;
    }

    public HD getReceivingApplication() {
        return this.receivingApplication;
    }

    public HD getReceivingFacility() {
        return this.receivingFacility;
    }

    public Date getMessageDateTime() {
        return this.messageDateTime;
    }

    public String getMessageType() {
        return MESSAGE_TYPE;
    }

    public String getMessageControlId() {
        return this.messageControlId;
    }

    public ProcessingId getProcessingId() {
        return PROCESSING_ID;
    }

    public String getVersionId() {
        return VERSION_ID;
    }

    public AcknowledgementType getAcceptAcknowledgementType() {
        return ACCEPT_ACKNOWLEDGEMENT_TYPE;
    }

    public AcknowledgementType getApplicationAcknowledgementType() {
        return APPLICATION_ACKNOWLEDGEMENT_TYPE;
    }

    public CountryCode getCountryCode() {
        return COUNTRY_CODE;
    }

    public static MSH parse(String parseValue) {
        ArgumentUtils.checkNotNull((Object)parseValue, (String)"parseValue");
        List<String> fields = Arrays.asList(parseValue.split("\\|"));
        if (fields.size() >= 17) {
            if (fields.get(0).compareTo(MSH_SEGMENT_NAME) != 0) {
                throw new IllegalArgumentException(String.format("Unable to parse MSH - Segment name is incorrect: \n\tActual Value: %s\n\tExpected Value: %s", fields.get(0), MSH_SEGMENT_NAME));
            }
            try {
                return new Builder().sendingApplication(new HD.Builder().namespace(fields.get(2)).build()).sendingFacility(HD.parse(fields.get(3))).receivingApplication(new HD.Builder().namespace(fields.get(4)).build()).receivingFacility(HD.parse(fields.get(5))).messageDateTime(MSH.parseDate(fields.get(6))).messageControlId(fields.get(9)).build();
            }
            catch (MDMValidationException e) {
                throw new IllegalArgumentException("Unable to parse MSH", e);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Unable to parse MSH - Invalid date/time pattern supplied:\n\tActual Value: %s\n\tExpected Format: %s", fields.get(6), MSH_DATE_TIME_PATTERN));
            }
        }
        throw new IllegalArgumentException("Unable to parse MSH - Invalid number of fields:\n\tActual: " + fields.size() + "\n\tExpected: " + 17);
    }

    private static Date parseDate(String string) throws ParseException {
        Date date;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(MSH_DATE_TIME_PATTERN);
            simpleDateFormat.setLenient(true);
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException e) {
            date = new SimpleDateFormat(MSH_LENIENT_DATE_TIME_PATTERN).parse(string);
        }
        return date;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MSH_SEGMENT_NAME);
        sb.append("|");
        sb.append(ENCODING_CHARACTERS);
        sb.append("|");
        sb.append(this.sendingApplication.toString());
        sb.append("|");
        sb.append(this.sendingFacility.toString());
        sb.append("|");
        sb.append(this.receivingApplication.toString());
        sb.append("|");
        sb.append(this.receivingFacility.toString());
        sb.append("|");
        sb.append(new SimpleDateFormat(MSH_DATE_TIME_PATTERN).format(this.messageDateTime));
        sb.append("|");
        sb.append("|");
        sb.append(MESSAGE_TYPE);
        sb.append("|");
        sb.append(this.messageControlId);
        sb.append("|");
        sb.append((Object)PROCESSING_ID);
        sb.append("|");
        sb.append(VERSION_ID);
        sb.append("|");
        sb.append("|");
        sb.append("|");
        sb.append((Object)ACCEPT_ACKNOWLEDGEMENT_TYPE);
        sb.append("|");
        sb.append((Object)APPLICATION_ACKNOWLEDGEMENT_TYPE);
        sb.append("|");
        sb.append(COUNTRY_CODE.getCode());
        sb.append("\r");
        return sb.toString();
    }

    public static final class Builder {
        private Date messageDateTime;
        private String messageControlId = "";
        private HD sendingApplication;
        private HD sendingFacility;
        private HD receivingApplication;
        private HD receivingFacility;

        public Builder messageDateTime(Date value) {
            this.messageDateTime = value;
            return this;
        }

        public Builder messageControlId(String value) {
            this.messageControlId = value;
            return this;
        }

        public Builder sendingApplication(HD value) {
            this.sendingApplication = value;
            return this;
        }

        public Builder sendingFacility(HD value) {
            this.sendingFacility = value;
            return this;
        }

        public Builder receivingApplication(HD value) {
            this.receivingApplication = value;
            return this;
        }

        public Builder receivingFacility(HD value) {
            this.receivingFacility = value;
            return this;
        }

        public MSH build() throws MDMValidationException {
            HashMap<String, List<String>> failedVariables = new HashMap<String, List<String>>();
            failedVariables.putAll(MDMValidation.confirmNotNull("sendingApplication", this.sendingApplication, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("sendingFacility", this.sendingFacility, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("receivingApplication", this.receivingApplication, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("receivingFacility", this.receivingFacility, true));
            failedVariables.putAll(MDMValidation.confirmNotNull("messageDateTime", this.messageDateTime, true));
            failedVariables.putAll(MDMValidation.confirmNotNullNorBlank("messageControlId", this.messageControlId, true));
            if (!failedVariables.isEmpty()) {
                throw new MDMValidationException("Invalid MSH segment", failedVariables);
            }
            return new MSH(this);
        }
    }
}

