/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.mdm.util;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.mdm.core.Message;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

public final class MDMUtil {
    private MDMUtil() {
    }

    public static void writeMDMMessageToFile(Message message, String path) throws IOException {
        ArgumentUtils.checkNotNull((Object)message, (String)"message");
        ArgumentUtils.checkNotNull((Object)path, (String)"path");
        BufferedWriter out = new BufferedWriter(new FileWriter(path));
        out.write(message.toString());
        ((Writer)out).close();
    }

    public static Message readMDMMessageFromFile(String path) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream is = new FileInputStream(path);
        byte[] buffer = new byte[2048];
        int count = ((InputStream)is).read(buffer);
        while (count != -1) {
            baos.write(buffer, 0, count);
            count = ((InputStream)is).read(buffer);
        }
        String fileContent = new String(baos.toByteArray());
        if (!fileContent.isEmpty()) {
            return Message.parse(fileContent);
        }
        return null;
    }
}

