﻿using IhiLookupBusinessLogic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using IhiLookup.Schemas;
using nehta.mcaR3.ConsumerSearchIHI;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using IhiPcehrCommonSchemas;
using PcehrBusinessLogic;
using PcehrSchemas;

namespace GeneralTestProject
{
    
    
    /// <summary>
    ///This is a test class for SearchTest and is intended
    ///to contain all SearchTest Unit Tests
    ///</summary>
    [TestClass()]
    public class SearchTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //

        [TestMethod()]
        public void ByNumberTest()
        {
            IhiSearchCriteria searchDetails = new IhiSearchCriteria();
            searchDetails.DateOfBirth = new DateTime(1984, 05, 26);
            searchDetails.DvaNumber = "N 908030F";
            searchDetails.MedicareNumber = "2950163131";
            searchDetails.MedicareSequenceNumber = "1";

            IhiSearchCriteriaName name = new IhiSearchCriteriaName();
            //name.GivenName = "Curry";
            //name.FamilyName = "Henry";
            name.GivenName = "DILBERT";
            name.FamilyName = "DOBSON";
            name.SuffixId = -1;
            name.TitleId = -1;
            name.Sex = SexEnumerator.Male;
            searchDetails.Names = new System.Collections.Generic.List<IhiSearchCriteriaName>();
            searchDetails.Names.Add(name);
            string message;
            searchIHIResponse response;
            UserDetails user = new UserDetails();
            user.Name = "Test User";
            user.Login = "Test";
            user.Role = UserRole.InteractiveUser;
            user.Domain = "TST";
            user.HpiO = "TEST-HPIO";
            bool result = Search.ByNumber(searchDetails, out message, out response, user, false);
            if (!result)
            {
                Assert.Fail("IHI not found.");
            }



            //IhiLoader target = new IhiLoader(); // TODO: Initialize to an appropriate value
            //string pasHospitalCode = "RAH"; // TODO: Initialize to an appropriate value
            //HospitalIdentifierNamespace hospitalIdentifierNamespace = HospitalIdentifierNamespace.PatientAdministrationSystem;
            //string mrn = "898799"; // TODO: Initialize to an appropriate value
            //DateTime dateOfBirth = new DateTime(1977, 01, 01); // TODO: Initialize to an appropriate value
            //IhiSearchResponse expected = null; // TODO: Initialize to an appropriate value
            //IhiSearchResponse actual;
            //actual = target.GetValidatedIhi(pasHospitalCode, hospitalIdentifierNamespace, mrn, dateOfBirth);
            //Assert.AreEqual(expected, actual);
            //Assert.Inconclusive("Verify the correctness of this test method.");
        }
        [TestMethod()]
        public void PcehrExistsTest()
        {
            UserDetails user = new UserDetails();
            user.Domain = "HAD";
            user.HpiI = "";
            user.HpiO = "8003624900000594";
            user.Login = "TestUser";
            user.Name = "Test User";
            user.Role = UserRole.AuthorisedEmployee;
            DoesPcehrExist check = new DoesPcehrExist();
            DoesPcehrExistResponse result = check.PcehrExists("8003602346555439", user);

            if (!result.PcehrExists.HasValue || result.PcehrExists.Value == false)
            {
                Assert.Fail("Not working.");
            }
        }
        #endregion

    }
}
