﻿#region Using Directives

using System;
using System.Collections.Generic;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrHiBusinessLogic.Pcehr;
using HIPS.PcehrDataStore.Schemas;
//using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.PcehrSchemas;
using HIPS.ServiceContracts.ServiceInterfaces;
using HIPS.PcehrDataStore.Schemas.Enumerators;


#endregion Using Directives

namespace HIPS.AppServer.ServiceHost
{
    /// <summary>
    /// Contains methods to assist in the registration of a patient with the PCEHR
    /// </summary>
    public class AssistedRegistrationService : BaseService, IAssistedRegistrationService
    {
        #region Methods

        /// <summary>
        /// Lists the patients without pcehr.
        /// </summary>
        /// <param name="hospitalCode">The hospital code.</param>
        /// <param name="hospitalCodeSystem">The hospital code system.</param>
        /// <returns>
        /// List of patients without a PCEHR
        /// </returns>
        public PatientWithoutPcehrResponse ListPatientsWithoutPcehr(string hospitalCodeSystem, string hospitalCode = null)
        {
            return PcehrRegistration.ListPatientsWithoutPcehr(hospitalCodeSystem, hospitalCode);
        }

        /// <summary>
        /// Registers the patient.
        /// </summary>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="identityType">Type of the identity.</param>
        /// <param name="indigenousStatus">The indigenous status.</param>
        /// <param name="documentConsent">The document consent.</param>
        /// <param name="correspondenceChannel">The correspondence channel.</param>
        /// <param name="acceptedTermsAndConditions">if set to <c>true</c> [accepted terms and conditions].</param>
        /// <param name="user">The user.</param>
        /// <param name="consentForm">The consent form.</param>
        /// <returns></returns>
        public PcehrRegistrationResponse RegisterPatient(PatientIdentifierBase patientIdentifier, EvidenceOfIdentityType identityType, IndigenousStatus indigenousStatus, List<RegistrationDocumentConsent> documentConsent, RegistrationCorrespondenceChannel correspondenceChannel, bool acceptedTermsAndConditions, UserDetails user, Attachment consentForm = null)
        {

            return PcehrRegistration.RegisterPatient(patientIdentifier, null, identityType, indigenousStatus, documentConsent, correspondenceChannel, acceptedTermsAndConditions, user, consentForm);
        }

        /// <summary>
        /// Reregisters the patient.
        /// </summary>
        /// <param name="patientMasterId">The patient master identifier.</param>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="identityType">Type of the identity.</param>
        /// <param name="indigenousStatus">The indigenous status.</param>
        /// <param name="documentConsent">The document consent.</param>
        /// <param name="correspondenceChannel">The correspondence channel.</param>
        /// <param name="acceptedTermsAndConditions">if set to <c>true</c> [accepted terms and conditions].</param>
        /// <param name="user">The user.</param>
        /// <param name="consentForm">The consent form.</param>
        /// <returns></returns>
        public PcehrRegistrationResponse ReregisterPatient(int patientMasterId, PatientIdentifierBase patientIdentifier, EvidenceOfIdentityType identityType, IndigenousStatus indigenousStatus, List<RegistrationDocumentConsent> documentConsent, RegistrationCorrespondenceChannel correspondenceChannel, bool acceptedTermsAndConditions, UserDetails user, Attachment consentForm = null)
        {

            return PcehrRegistration.RegisterPatient(patientIdentifier, null, identityType, indigenousStatus, documentConsent, correspondenceChannel, acceptedTermsAndConditions, user, consentForm, patientMasterId);
        }

        /// <summary>
        /// Registers the dependant.
        /// </summary>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="representativeDemographics">The representative demographics.</param>
        /// <param name="identityType">Type of the identity.</param>
        /// <param name="indigenousStatus">The indigenous status.</param>
        /// <param name="documentConsent">The document consent.</param>
        /// <param name="correspondenceChannel">The correspondence channel.</param>
        /// <param name="acceptedTermsAndConditions">if set to <c>true</c> [accepted terms and conditions].</param>
        /// <param name="user">The user.</param>
        /// <param name="consentForm">The consent form.</param>
        /// <returns></returns>
        public PcehrRegistrationResponse RegisterDependant(PatientIdentifierBase patientIdentifier, Demographic representativeDemographics, EvidenceOfIdentityType identityType, IndigenousStatus indigenousStatus, List<RegistrationDocumentConsent> documentConsent, RegistrationCorrespondenceChannel correspondenceChannel, bool acceptedTermsAndConditions, bool representativeDeclaration, UserDetails user, Attachment consentForm = null)
        {

            return PcehrRegistration.RegisterPatient(patientIdentifier, representativeDemographics, identityType, indigenousStatus, documentConsent, correspondenceChannel, acceptedTermsAndConditions, user, consentForm, 0, true , representativeDeclaration);
        }

        /// <summary>
        /// Reregisters the dependant.
        /// </summary>
        /// <param name="patientMasterId">The patient master identifier.</param>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="representativeDemographics">The representative demographics.</param>
        /// <param name="identityType">Type of the identity.</param>
        /// <param name="indigenousStatus">The indigenous status.</param>
        /// <param name="documentConsent">The document consent.</param>
        /// <param name="correspondenceChannel">The correspondence channel.</param>
        /// <param name="acceptedTermsAndConditions">if set to <c>true</c> [accepted terms and conditions].</param>
        /// <param name="user">The user.</param>
        /// <param name="consentForm">The consent form.</param>
        /// <returns></returns>
        public PcehrRegistrationResponse ReregisterDependant(int patientMasterId, PatientIdentifierBase patientIdentifier, Demographic representativeDemographics, EvidenceOfIdentityType identityType, IndigenousStatus indigenousStatus, List<RegistrationDocumentConsent> documentConsent, RegistrationCorrespondenceChannel correspondenceChannel, bool acceptedTermsAndConditions, bool representativeDeclaration, UserDetails user, Attachment consentForm = null)
        {

            return PcehrRegistration.RegisterPatient(patientIdentifier, representativeDemographics, identityType, indigenousStatus, documentConsent, correspondenceChannel, acceptedTermsAndConditions, user, consentForm, patientMasterId, true, representativeDeclaration);
        }

        #endregion Methods
    }
}