﻿#region Using Directives

using System;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.HpiiSchemas;
using HIPS.IhiSchemas.Schemas;
using HIPS.PcehrHiBusinessLogic.Ihi;
using HIPS.ServiceContracts.ServiceInterfaces;
using HIPS.PcehrHiBusinessLogic.Hpii;

#endregion Using Directives

namespace HIPS.AppServer.ServiceHost
{
    /// <summary>
    /// This class implements web services for obtaining a validated IHI from the HI Service.
    /// </summary>
    public class HpiiService : BaseService, IHpiiService
    {
        /// <summary>
        /// Performs an HPII Validation query against the HPII Service.
        /// </summary>
        /// <param name="hpiiIdentifierQuery">The HPII identifier query.</param>
        /// <param name="user">The user.</param>
        /// <returns>Validated HPII information</returns>
        public HpiiQueryResponse HpiiValidation(HpiiIdentifierQuery hpiiIdentifierQuery, UserDetails user)
        {
            return new HpiiSearch().HpiiValidation(hpiiIdentifierQuery, user);
        }

        /// <summary>
        /// Performs an HPII Demographic query against the HPII Service.
        /// </summary>
        /// <param name="hpiiDemographicQuery">The HPII demographic query.</param>
        /// <param name="user">The user.</param>
        /// <returns>Found HPII information</returns>
        public HpiiQueryResponse HpiiDemographicSearch(HpiiDemographicQuery hpiiDemographicQuery, UserDetails user)
        {
            return new HpiiSearch().HpiiDemographicSearch(hpiiDemographicQuery, user);
        }

        /// <summary>
        /// Performs an HPII Batch Submit query against the HPII Service.
        /// </summary>
        /// <param name="hpiiBatchAsyncSubmitRequest">The hpii batch asynchronous submit request.</param>
        /// <param name="user">The user.</param>
        /// <returns>
        /// Validated HPII information
        /// </returns>
        public HpiiBatchAsyncSubmitResponse HpiiBatchSubmit(HpiiBatchAsyncSubmitRequest hpiiBatchAsyncSubmitRequest, UserDetails user)
        {
            return new HpiiSearch().HpiiBatchSubmit(hpiiBatchAsyncSubmitRequest, user);
        }

        /// <summary>
        /// Performs an HPII Batch Retrieve query against the HPII Service.
        /// </summary>
        /// <param name="hpiiIdentifierQuery">The HPII identifier query.</param>
        /// <param name="user">The user.</param>
        /// <returns>
        /// Validated HPII information
        /// </returns>
        public HpiiBatchAsyncRetrieveResponse HpiiBatchRetrieve(HpiiBatchAsyncRetrieveRequest hpiiBatchAsyncRetrieveRequest, UserDetails user)
        {
            return new HpiiSearch().HpiiBatchRetrieve(hpiiBatchAsyncRetrieveRequest, user);
        }


    }
}