﻿#region Using Directives

using System;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.IhiSchemas.Schemas;
using HIPS.PcehrHiBusinessLogic.Ihi;
using HIPS.ServiceContracts.ServiceInterfaces;

#endregion Using Directives

namespace HIPS.AppServer.ServiceHost
{
    /// <summary>
    /// This class implements web services for obtaining a validated IHI from the HI Service.
    /// </summary>
    public class IHIService : BaseService, IIHIService
    {
        /// <summary>
        /// Retrieves a valid IHI and registered demographics for use in a clinical document.
        /// </summary>
        /// <param name="patientIdentifier">An identifier for the patient, such as the medical record number at the hospital, or an enterprise patient identifier.</param>
        /// <param name="dateOfBirth">The patient's date of birth (as an additional identity check).</param>
        /// <param name="user">The health provider individual, interactive user or authorised employee responsible for this action.</param>
        /// <returns>Validated IHI Response containing success or failure information, MRN, enterprise patient identifier and validated IHI information.</returns>
        public ValidatedIhiResponse GetValidatedIhi(PatientIdentifierBase patientIdentifier, DateTime dateOfBirth, UserDetails user)
        {
            return new PatientIhiValidation().GetValidatedIhi(patientIdentifier, dateOfBirth, user);
        }
    }
}