﻿#region Using Directives

using System;
using System.Collections.Generic;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrHiBusinessLogic.Pcehr;
using HIPS.PcehrDataStore.Schemas;
//using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.PcehrSchemas;
using HIPS.ServiceContracts.ServiceInterfaces;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.PatientSchemas;
using HIPS.PatientBusinessLogic;


#endregion Using Directives

namespace HIPS.AppServer.ServiceHost
{
    /// <summary>
    /// Contains methods to assist in the registration of a patient with the PCEHR
    /// </summary>
    public class PatientService : BaseService, IPatientService
    {
        #region Methods

        /// <summary>
        /// Lists admitted or recently discharged patients in hospital with or without a PCEHR.
        /// </summary>
        /// <param name="user">The user who is requesting the information.</param>
        /// <param name="hospitalCodeSystem">The hospital code system.</param>
        /// <param name="hospitalCode">The hospital code.</param>
        /// <param name="withPcehr">True to list patients with a PCEHR, false to list patients without a PCEHR. Null for all patients.</param>
        /// <param name="daysDischarged">Number of days after discharge that patients are included in the list. Set to 0 to list only currently admitted patients.</param>
        /// <returns>A patient list response with status and a list of patients in hospital.</returns>
        public PatientListResponse ListPatientsInHospital(UserDetails user, string hospitalCodeSystem, string hospitalCode, bool? withPcehr, int daysDischarged)
        {
            PatientListLogic logic = new PatientListLogic();
            PatientListResponse response = logic.ListPatientsInHospital(user, hospitalCodeSystem, hospitalCode, withPcehr, daysDischarged);
            return response;
        }

        #endregion Methods
    }
}