﻿namespace HIPS.Base.Schemas.Enumerators
{
    public enum SecurityGroup
    {
        None,
        Admin,
        Read,
        Write,
        Finalise
    }

    public enum DatabaseColumnType
    {
        /// <summary>
        /// This property is an Auto-Increment column in SQL. Does not get passed as a parameter into Insert Statements. (Update, Delete)
        /// </summary>
        AutoGeneratedKey,

        /// <summary>
        /// This property forms part of the objects key, but is generated by the application and is passed through to All sprocs (Insert, Update, Delete)
        /// </summary>
        ApplicationGeneratedKey,

        /// <summary>
        /// This property is pure data only (Insert, Update)
        /// </summary>
        Data,

        /// <summary>
        /// This property is data, but only passed through to Update Sprocs (Update)
        /// </summary>
        UpdateData,

        /// <summary>
        /// This property is data, but get passed through to Update and Delete Sprocs (Update, Delete)
        /// </summary>
        UpdateDeleteData,

        /// <summary>
        ///
        /// </summary>
        ReadOnlyData,
    }

    /// <summary>
    /// The type of name. int links back to the NameType table
    /// </summary>
    public enum NameTypes
    {
        Legal = 1,
        Current = 2,
        Previous = 3
    }

    /// <summary>
    /// The method of contact details. int links back to the ContactsMethod table
    /// </summary>
    public enum ContactMethods
    {
        HomePhone = 1,
        HomeFax = 2,
        PersonalMobile = 3,
        PersonalEmail = 4,
        Pager = 5,
        WorkPhone = 6,
        WorkFax = 7,
        WorkMobile = 8,
        WorkEmail = 9
    }
}