﻿using System;
using System.Runtime.Serialization;

namespace HIPS.Base.Schemas
{
    [KnownType(typeof(BaseCodeListSchema))]
    [Serializable]
    [DataContract]
    public class BaseCodeListSchema : BaseListSchema
    {
        #region Private Members

        private string code;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the code.
        /// </summary>
        /// <value>
        /// The code.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(Enumerators.DatabaseColumnType.Data)]
        public string Code
        {
            get
            {
                return code;
            }
            set
            {
                Set(() => Code, ref this.code, value);
            }
        }

        #endregion Properties
    }
}