﻿using HIPS.Base.Schemas.Enumerators;
using System;
using System.Runtime.Serialization;

namespace HIPS.Base.Schemas
{
    [Serializable]
    [DataContract]
    [KnownType(typeof(BaseExposedCode))]
    public class BaseExposedCode
    {
        public BaseExposedCode(){}
       

        #region Private Members
        
        private int? id;
        private string code;
        private string description;
        
        #endregion
        
        /// <summary>
        /// Gets or Sets the Id
        /// </summary>
        /// <value>
        /// The Id
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        [DataMember]
        public int? Id
        {
            get { return id; }
            set { id = value; }
        }

        /// <summary>
        /// Gets or Sets the Code
        /// </summary>
        /// <value>
        /// The code
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        [DataMember]
        public string Code
        {
            get { return code; }
            set { code = value; }
        }

        /// <summary>
        /// Gets or Sets the Description
        /// </summary>
        /// <value>
        /// The description
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        [DataMember]
        public string Description
        {
            get { return description; }
            set { description = value; }
        }


        

    }
}


