﻿using System;
using System.Runtime.Serialization;

namespace HIPS.Base.Schemas
{
    [KnownType(typeof(BaseInformationSchema))]
    [Serializable]
    [DataContract]
    public class BaseInformationSchema : BaseSchema
    {
        #region private members

        private bool itemToBeViewed = true;
        private bool newItem = true;

        #endregion private members

        #region Properties

        /// <summary>
        /// Gets or sets a value indicating whether this item has yet to be viewed.
        /// </summary>
        /// <value>
        ///   <c>true</c> if [item to be viewed]; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool ItemToBeViewed
        {
            get
            {
                return itemToBeViewed;
            }

            set
            {
                itemToBeViewed = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => ItemToBeViewed);
#endif
            }
        }

        /// <summary>
        /// Gets or sets a value indicating whether this item is new since the last update.
        /// </summary>
        /// <value>
        ///   <c>true</c> if [new item]; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool NewItem
        {
            get
            {
                return newItem;
            }

            set
            {
                newItem = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => NewItem);
#endif
            }
        }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is compare mode.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is compare mode; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool IsCompareMode { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>

        #endregion Properties

        #region Methods

        /// <summary>
        /// Formatteds the date time.
        /// </summary>
        /// <param name="date">The date.</param>
        /// <param name="timeOnNewLine">if set to <c>true</c> [time on new line].</param>
        /// <returns></returns>
        public string FormattedDateTime(DateTime? date, bool timeOnNewLine = false)
        {
            if (!date.HasValue)
            {
                return string.Empty;
            }
            if (timeOnNewLine == false)
            {
                return date.Value.ToString("dd/MM/yyyy t");
            }
            return string.Format("{0:dd/MM/yyyy}{1}{2:t}", date, System.Environment.NewLine, date);
        }

        /// <summary>
        /// Formatteds the date.
        /// </summary>
        /// <param name="date">The date.</param>
        /// <returns></returns>
        public string FormattedDate(DateTime? date)
        {
            if (!date.HasValue)
            {
                return string.Empty;
            }
            return date.Value.ToString("dd/MM/yyyy");
        }

        #endregion Methods
    }
}