﻿using System;
using System.Runtime.Serialization;

namespace HIPS.Base.Schemas
{
    [KnownType(typeof(BaseListSchema))]
    [Serializable]
    [DataContract]
    public class BaseListSchema : BaseSchema
    {
        #region Private Members

        private string description;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        /// <value>
        /// The description.
        /// </value>
        [DataBaseInfoAttributes(Enumerators.DatabaseColumnType.Data)]
        [DataMember]
        public string Description
        {
            get
            {
                return description;
            }
            set
            {
                description = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => Description);
#endif
            }
        }

        #endregion Properties

        #region Overrides

        public override string ToString()
        {
            return Description;
        }

        #endregion Overrides
    }
}