﻿using System;
using System.Reflection;
using System.Runtime.Serialization;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.Base.Schemas
{
    /// <summary>
    /// Base schema
    /// </summary>
    [KnownType(typeof(BaseSchema))]
    [Serializable]
    [DataContract]
    public class BaseSchema : HipsObservableObject
    {
        #region Private members

        private int? id;
        private DateTime dateCreated;
        private DateTime dateModified;
        private string userCreated;
        private string userModified;

        #endregion Private members

        #region Properties

        [DataMember]
        public int? Id
        {
            get
            {
                return id;
            }
            set
            {
                id = value;
            }
        }

        // Summary:
        //     Gets/Set the Date and Time that this record was created
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        [DataMember]
        public DateTime DateCreated
        {
            get
            {
                return dateCreated;
            }
            set
            {
                dateCreated = value;
            }
        }

        //
        // Summary:
        //     Gets/set the Date and Time that this record was last modified
        [DataBaseInfoAttributes(DatabaseColumnType.UpdateData)]
        [DataMember]
        public DateTime DateModified
        {
            get
            {
                return dateModified;
            }
            set
            {
                dateModified = value;
            }
        }

        //
        // Summary:
        //     Get/Set the user who created this record
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        [DataMember]
        public string UserCreated
        {
            get
            {
                return userCreated;
            }
            set
            {
                userCreated = value;
            }
        }

        //
        // Summary:
        //     Gets/Set the user who last modified this record
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        [DataMember]
        public virtual string UserModified
        {
            get
            {
                return userModified;
            }
            set
            {
                userModified = value;
            }
        }

        #endregion Properties

        #region Methods

        public void Update<T>(T sourceItem)
        {
            PropertyInfo[] fromFields = typeof(T).GetProperties();
            for (int count = 0; count < fromFields.Length; count++)
            {
                PropertyInfo fromField = (PropertyInfo)fromFields[count];
                if (fromField.CanWrite)
                {
                    //PropertyInfo toField = (PropertyInfo)toFields[count];
                    object value = fromField.GetValue(sourceItem, null);
                    fromField.SetValue(this, value, null);
                }
            }
        }

        #endregion Methods

        #region Proprty Changed Events

        #endregion Proprty Changed Events
    }
}