﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.Base.Schemas
{
    /// <summary>
    /// This class represents an entry in the system log.
    /// </summary>
    [KnownType(typeof(SystemErrorLog))]
    [Serializable]
    [DataContract]
    public class SystemErrorLog : BaseSchema
    {
        #region Private Members

        private int logMessageId;
        private string message;
        private string exceptionMessage;

        #endregion Private Members

        /// <summary>
        /// Gets or sets the system error log identifier (primary key for an entry in the log).
        /// </summary>
        /// <value>
        /// The log entry identifier.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.AutoGeneratedKey)]
        [DataMember]
        public int? SystemErrorLogId
        {
            get
            {
                return this.Id;
            }
            set
            {
                this.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the log message identifier (foreign key to the definition of the log message).
        /// </summary>
        /// <value>
        /// The log message identifier.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        [DataMember]
        public int LogMessageId
        {
            get
            {
                return this.logMessageId;
            }
            set
            {
                this.logMessageId = value;
            }
        }

        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        /// <value>
        /// The message.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        [DataMember]
        public string Message
        {
            get
            {
                return this.message;
            }
            set
            {
                this.message = value;
            }
        }

        /// <summary>
        /// Gets or sets the exception message.
        /// </summary>
        /// <value>
        /// The exception message.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        [DataMember]
        public string ExceptionMessage
        {
            get
            {
                return this.exceptionMessage;
            }
            set
            {
                this.exceptionMessage = value;
            }
        }
    }
}