﻿using System;
using System.Diagnostics;
using System.Xml.Serialization;

namespace HIPS.BusinessEntities.ResponseEntities
{
    [Serializable]
    [DebuggerStepThrough]
    [XmlRoot(Namespace = "http://schemas.HIPS/WebServices/2012/01", ElementName = "HospitalDetailsResponse")]
    [XmlType(Namespace = "http://schemas.HIPS/WebServices/2012/01", IncludeInSchema = true)]
    public class HospitalDetailsResponse
    {
        public HospitalDetailsResponse()
        {
            _hospitalDetailsResult = new HospitalDetailsResult();
        }

        private HospitalDetailsResult _hospitalDetailsResult;

        [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 0)]
        public HospitalDetailsResult GetHospitalDetailsResult
        {
            get { return _hospitalDetailsResult; }
            set { _hospitalDetailsResult = value; }
        }

        public class HospitalDetailsResult
        {
            public HospitalDetailsResult()
            {
            }

            private string fax;
            private string phone;
            private string hospitalName;
            private string hpio;
            private string addressLine1;
            private string addressLine2;
            private string placeName;
            private string state;
            private string postcode;

            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 0)]
            public string Fax
            {
                get { return this.fax; }
                set { this.fax = value; }
            }

            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 1)]
            public string Phone
            {
                get { return this.phone; }
                set { this.phone = value; }
            }

            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 2)]
            public string HospitalName
            {
                get { return this.hospitalName; }
                set { this.hospitalName = value; }
            }

            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 3)]
            public string Hpio
            {
                get { return this.hpio; }
                set { this.hpio = value; }
            }

            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 4)]
            public string AddressLine1
            {
                get { return this.addressLine1; }
                set { this.addressLine1 = value; }
            }

            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 5)]
            public string AddressLine2
            {
                get { return this.addressLine2; }
                set { this.addressLine2 = value; }
            }

            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 6)]
            public string PlaceName
            {
                get { return this.placeName; }
                set { this.placeName = value; }
            }

            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 7)]
            public string State
            {
                get { return this.state; }
                set { this.state = value; }
            }

            [XmlElement(Namespace = "http://schemas.HIPS/WebServices/2012/01", Order = 8)]
            public string Postcode
            {
                get { return this.postcode; }
                set { this.postcode = value; }
            }
        }
    }
}