﻿#region Using Directives

using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.HpiiSchemas;
using HIPS.ServiceContracts.ServiceInterfaces;

#endregion Using Directives

namespace HIPS.Client.Proxy
{
    /// <summary>
    ///
    /// </summary>
    public class HpiiProxy : ClientBase<IHpiiService>, IHpiiService
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="IHIProxy"/> class.
        /// </summary>
        /// <param name="endpointName">The endpoint configuration name</param>
        public HpiiProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Performs an HPII Validation query against the HPII Service.
        /// </summary>
        /// <param name="hpiiIdentifierQuery">The HPII identifier query.</param>
        /// <param name="user">The user.</param>
        /// <returns>Validated HPII information</returns>
        public HpiiQueryResponse HpiiValidation(HpiiIdentifierQuery hpiiIdentifierQuery, UserDetails user)
        {
            return Channel.HpiiValidation(hpiiIdentifierQuery, user);
        }

        /// <summary>
        /// Performs an HPII Demographic query against the HPII Service.
        /// </summary>
        /// <param name="hpiiDemographicQuery">The HPII demographic query.</param>
        /// <param name="user">The user.</param>
        /// <returns>Found HPII information</returns>
        public HpiiQueryResponse HpiiDemographicSearch(HpiiDemographicQuery hpiiDemographicQuery, UserDetails user)
        {
            return Channel.HpiiDemographicSearch(hpiiDemographicQuery, user);
        }

        /// <summary>
        /// Performs an HPII Batch Submit against the HPII Service.
        /// </summary>
        /// <param name="hpiiBatchAsyncSubmitRequest">The hpii batch asynchronous submit request.</param>
        /// <param name="user">The user.</param>
        /// <returns>
        /// Found HPII information
        /// </returns>
        public HpiiBatchAsyncSubmitResponse HpiiBatchSubmit(HpiiBatchAsyncSubmitRequest hpiiBatchAsyncSubmitRequest, UserDetails user)
        {
            return Channel.HpiiBatchSubmit(hpiiBatchAsyncSubmitRequest, user);
        }

        /// <summary>
        /// Performs an HPII Batch Retrieve against the HPII Service.
        /// </summary>
        /// <param name="hpiiIdentifierQuery">The HPII demographic query.</param>
        /// <param name="user">The user.</param>
        /// <returns>Found HPII information</returns>
        public HpiiBatchAsyncRetrieveResponse HpiiBatchRetrieve(HpiiBatchAsyncRetrieveRequest hpiiBatchAsyncRetrieveRequest, UserDetails user)
        {
            return Channel.HpiiBatchRetrieve(hpiiBatchAsyncRetrieveRequest, user);
        }
    }
}