﻿#region Using Directives

using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.PatientSchemas;
using HIPS.ServiceContracts.ServiceInterfaces;

#endregion Using Directives

namespace HIPS.Client.Proxy
{
    /// <summary>
    /// This pre-built client class can be referenced by a .net client application in lieu of generating client classes from the WSDL.
    /// </summary>
    public class PatientProxy : ClientBase<IPatientService>, IPatientService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public PatientProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Lists admitted or recently discharged patients, who have an active
        /// IHI, with or without a PCEHR.
        /// </summary>
        /// <param name="user">The name and identifier of the person who is
        ///     responsible for this action, typically the user who is operating
        ///     the application (required).</param>
        /// <param name="hospitalCodeSystem">The hospital code system (required).
        ///     This parameter filters which hospitals and codes are returned.</param>
        /// <param name="hospitalCode">The hospital code (optional). Send null
        ///     to include all hospitals that have a code in the code system.</param>
        /// <param name="withPcehr">True to list patients with a PCEHR, false
        ///     to list patients without a PCEHR. Null to include patients with
        ///     or without a PCEHR.</param>
        /// <param name="daysDischarged">Number of days after discharge that
        ///     patients are included in the list. Set to 0 to list only
        ///     currently admitted patients.</param>
        /// <returns>A patient list response with status and a list of patients in hospital.</returns>
        public PatientListResponse ListPatientsInHospital(UserDetails user, string hospitalCodeSystem, string hospitalCode, bool? withPcehr, int daysDischarged)
        {
            return Channel.ListPatientsInHospital(user, hospitalCodeSystem, hospitalCode, withPcehr, daysDischarged);
        }
    }
}