﻿namespace HIPS.CommonSchemas
{
    /// <summary>
    /// The role of the user
    /// </summary>
    public enum UserRole
    {
        /// <summary>
        /// Individual Healthcare Provider identified by an HPI-I
        /// </summary>
        ProviderIndividual,

        /// <summary>
        /// Interactive access by clinician or patient administration clerk etc.
        /// </summary>
        InteractiveUser,

        /// <summary>
        /// Authorised employee responsible for non-interactive access by batch or background processes
        /// </summary>
        AuthorisedEmployee,
    }


    /// <summary>
    /// The CodeSystem enumeration
    /// </summary>
    public enum CodeSystemCode
    {
        /// <summary>
        /// Used as the code system for the Hi Reference tables
        /// </summary>
        HI_ReferenceCodes = 106
    }


    /// <summary>
    /// This enumeration indicates the success or category of failure.
    ///
    /// *******************************************************************************
    /// Use CAUTION when modifying the values in this enumeration as it will affect the
    /// calling systems that are integrated with HIPS.
    ///
    /// For example, the Health Integration Broker (HIB) at SA Health has a lookup table
    /// to determine the type of processing required for each value in the enumeration.
    /// *******************************************************************************
    /// 
    /// </summary>
    public enum HipsResponseIndicator
    {
        /// <summary>
        /// The application failed. Details recorded within the application database.
        /// </summary>
        SystemError = 0,

        /// <summary>
        /// The request executed correctly
        /// </summary>
        OK = 1,

        /// <summary>
        /// The patient was not found with the specified search data
        /// </summary>
        InvalidPatient = 2,

        /// <summary>
        /// The hospital was not found with the specified search data
        /// </summary>
        InvalidHospital = 3,

        /// <summary>
        /// The episode was not found with the specified search data
        /// </summary>
        InvalidEpisode = 4,

        /// <summary>
        /// The document was not found with the specified search data
        /// </summary>
        InvalidDocument = 5,

        /// <summary>
        /// The user was not correctly specified
        /// </summary>
        InvalidUser = 6,

        /// <summary>
        /// The HI service returned an error
        /// </summary>
        HiServiceError = 8,

        /// <summary>
        /// The PCEHR service returned an error
        /// </summary>
        PcehrServiceError = 9,

        /// <summary>
        /// The patient's IHI could not be found or validated
        /// </summary>
        InvalidIhi = 10,

        /// <summary>
        /// The document could not be uploaded because consent was withdrawn
        /// </summary>
        ConsentWithdrawn = 11,

        /// <summary>
        /// HIPS could not add the operation (upload or remove) to the MSMQ queue.
        /// This can happen if the queue is full. The calling system should retry
        /// the operation.
        /// </summary>
        CouldNotAddToQueue = 12,

        /// <summary>
        /// The Access Code is invalid.
        /// </summary>
        InvalidAccessCode = 13,

        /// <summary>
        /// Demographics in the downloaded document did not match those in the local system.
        /// This will occur when the Date of Birth, Sex or Family Name are different.
        /// </summary>
        DemographicMismatchWarning = 14,

        /// <summary>
        /// The IHI for this patient has an unresolved alert. This patient's PCEHR cannot be
        /// accessed until the alert has been resolved.
        /// </summary>
        UnresolvedIhiAlert = 15,

        /// <summary>
        /// The operation could not be completed because the local SQL Server database is
        /// unavailable. The calling system should retry the operation.
        /// </summary>
        DatabaseError = 16,

        /// <summary>
        /// The date of birth stored for the patient does not match
        /// the date of birth that was specified in the request.
        /// </summary>
        InvalidDateOfBirth = 17,

        /// <summary>
        /// The action was successful but returned one or more warnings that should be
        /// investigated as available resources permit.
        /// </summary>
        PcehrServiceWarning = 18,

        /// <summary>
        /// The PCEHR Service is temporarily unavailable. The action should be tried again later.
        /// In the case of an upload or remove operation, the queue transaction will be rolled
        /// back so that the MSMQ will handle retrying.
        /// </summary>
        PcehrServiceUnavailable = 19,

        /// <summary>
        /// The document was not uploaded because the patient was under the configured minimum
        /// age at the time of admission. This is a patient safety initiative of SA Health.
        /// </summary>
        PatientUnderAge = 20,

        /// <summary>
        /// This queue item could not be found - it may have been removed from the list or the ID is invalid
        /// </summary>
        CouldNotFindQueueItem = 21,

        /// <summary>
        /// There was a validation error. Check the HIPS error message and the response code, 
        /// description and detail for more information.
        /// </summary>
        ValidationError = 22,
    }

    ///*******************************************************************************
    /// Use CAUTION when modifying the values in this enumeration as it will affect the
    /// calling systems that are integrated with HIPS.
    ///
    /// For example, the Health Integration Broker (HIB) at SA Health has a lookup table
    /// to determine the type of processing required for each value in the enumeration.
    /// *******************************************************************************
}