﻿// -----------------------------------------------------------------------
// <copyright file="PatientStubException.cs" company="NEHTA">
// Developed by Chamonix for NEHTA.
// </copyright>
// -----------------------------------------------------------------------

using System;

namespace HIPS.CommonSchemas.Exceptions
{
    /// <summary>
    /// Indicates an error inserting the patient stub for validated IHI operation of HIPS.
    /// </summary>
    public class PatientStubException : Exception
    {
        /// <summary>
        /// Creates an exception indicating an error inserting the patient stub
        /// for validated IHI operation of HIPS.
        /// </summary>
        /// <param name="message">The reason for the exception</param>
        public PatientStubException(string message)
            : base(message)
        {
        }
    }
}