﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.CommonSchemas.Hi
{
    /// <summary>
    /// This class represents a HI Country for Addressing
    /// </summary>
    [KnownType(typeof(HiCountry))]
    [Serializable]
    [DataContract]
    public class HiCountry : BaseExposedCode
    {

        public HiCountry() : base()
        {
        }

        /// <summary>
        /// Gets or sets the Country id.
        /// </summary>
        /// <value>
        /// The Country id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? CountryId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}