﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.CommonSchemas.Hi
{
    /// <summary>
    /// This class represents a HI Unit Type for Addressing
    /// </summary>
    [KnownType(typeof(HiUnitType))]
    [Serializable]
    [DataContract]
    public class HiUnitType : BaseExposedCode
    {
        public HiUnitType() : base()
        {
        }


        /// <summary>
        /// Gets or sets the Unit Type id.
        /// </summary>
        /// <value>
        /// The unit type  id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? UnitTypeId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}