﻿using System.Runtime.Serialization;
using System.Text;

namespace HIPS.CommonSchemas
{
    /// <summary>
    /// Standardised HIPS Response Message
    /// </summary>

    [KnownType(typeof(HipsResponse))]
    [DataContract]
    public class HipsResponse
    {
        #region Private Members

        private HipsResponseIndicator status;
        private string responseCode;
        private string responseCodeDescription;
        private string responseCodeDetails;
        private string hipsErrorMessage;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the Status Indicator
        /// </summary>
        /// <value>
        /// Status
        /// </value>
        [DataMember]
        public HipsResponseIndicator Status
        {
            get
            {
                return status;
            }
            set
            {
                status = value;
            }
        }

        /// <summary>
        /// Gets or sets the Response Code
        /// </summary>
        /// <value>
        /// ResponseCode String
        /// </value>
        [DataMember]
        public string ResponseCode
        {
            get
            {
                return responseCode;
            }
            set
            {
                responseCode = value;
            }
        }

        /// <summary>
        /// Gets or sets the Response Code Description
        /// </summary>
        /// <value>
        /// ResponseCodeDescription String
        /// </value>
        [DataMember]
        public string ResponseCodeDescription
        {
            get
            {
                return responseCodeDescription;
            }
            set
            {
                responseCodeDescription = value;
            }
        }

        /// <summary>
        /// Gets or sets the Response Code Details
        /// </summary>
        /// <value>
        /// ResponseCodeDetails String
        /// </value>
        [DataMember]
        public string ResponseCodeDetails
        {
            get
            {
                return responseCodeDetails;
            }
            set
            {
                responseCodeDetails = value;
            }
        }

        /// <summary>
        /// Gets or sets the HipsError Message, if an error in HIPS is thrown
        /// </summary>
        /// <value>
        /// HipsErrorMessage String
        /// </value>
        [DataMember]
        public string HipsErrorMessage
        {
            get
            {
                return hipsErrorMessage;
            }
            set
            {
                hipsErrorMessage = value;
            }
        }

        #endregion Properties

        #region Constructors

        public HipsResponse(HipsResponseIndicator status, string hipsErrorMessage = null)
        {
            this.status = status;
            this.hipsErrorMessage = hipsErrorMessage;
        }

        #endregion Constructors

        #region Methods

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder(status.ToString());
            if (!string.IsNullOrEmpty(responseCode))
            {
                sb.AppendFormat(", Code: {0}", responseCode);
            }
            if (!string.IsNullOrEmpty(responseCodeDescription))
            {
                sb.AppendFormat(", Description: {0}", responseCodeDescription);
            }
            if (!string.IsNullOrEmpty(responseCodeDetails))
            {
                sb.AppendFormat(", Details: {0}", responseCodeDetails);
            }
            if (!string.IsNullOrEmpty(hipsErrorMessage))
            {
                sb.AppendFormat(", Message: {0}", hipsErrorMessage);
            }
            return sb.ToString();
        }

        #endregion Methods
    }
}