﻿using System;
using System.Runtime.Serialization;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.CommonSchemas.PatientIdentifier
{
    /// <summary>
    /// This Patient Identifier is used for the Demographics only
    /// </summary>
    [Serializable]
    [DataContract]
    public class Demographic : PatientIdentifierBase
    {
        #region Private Members

        private string familyName;
        private string givenName;
        private DateTime dateOfBirth;
        private SexEnumerator sex;
        private string medicareNumber;
        private string medicareIrn;
        private string dvaNumber;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// The family name that was used to obtain or validate the IHI with the HI Service.
        /// </summary>
        [DataMember]
        public string FamilyName
        {
            get
            {
                return familyName;
            }
            set
            {
                familyName = value;
            }
        }

        /// <summary>
        /// The given name that was used to obtain or validate the IHI with the HI Service.
        /// </summary>
        [DataMember]
        public string GivenName
        {
            get
            {
                return givenName;
            }
            set
            {
                givenName = value;
            }
        }

        /// <summary>
        /// The date of birth that was used to obtain or validate the IHI with the HI Service.
        /// </summary>
        [DataMember]
        public DateTime DateOfBirth
        {
            get
            {
                return dateOfBirth;
            }
            set
            {
                dateOfBirth = value;
            }
        }

        /// <summary>
        /// The sex that was used to obtain or validate the IHI with the HI Service.
        /// </summary>
        [DataMember]
        public SexEnumerator Sex
        {
            get
            {
                return sex;
            }
            set
            {
                sex = value;
            }
        }


        [DataMember]
        public string MedicareNumber
        {
            get
            {
                return medicareNumber;
            }
            set
            {
                medicareNumber = value;
            }
        }


        [DataMember]
        public string MedicareIrn
        {
            get
            {
                return medicareIrn;
            }
            set
            {
                medicareIrn = value;
            }
        }

        [DataMember]
        public string DvaNumber
        {
            get
            {
                return dvaNumber;
            }
            set
            {
                dvaNumber = value;
            }
        }
        #endregion Properties

        #region Methods

        public override string ToString()
        {
            return string.Format("Family Name {0} Given Name {1}", familyName, givenName);
        }

        /// <summary>
        /// Specific constructor for a validated IHI identifier.
        /// </summary>
        /// <param name="ihi">The IHI</param>
        /// <param name="ihiStatus">The IHI status</param>
        /// <param name="ihiRecordStatus">The IHI record status</param>
        /// <param name="ihiLastValidated">The date/time when the IHI was obtained or last validated</param>
        /// <param name="familyName">The family name that was used to obtain or validate the IHI with the HI Service</param>
        /// <param name="givenName">The given name that was used to obtain or validate the IHI with the HI Service</param>
        /// <param name="dateOfBirth">The date of birth that was used to obtain or validate the IHI with the HI Service</param>
        /// <param name="sex">The sex that was used to obtain or validate the IHI with the HI Service</param>
        /// <param name="hospitalCode">A code identifying the hospital in which this patient receives health care</param>
        /// <param name="hospitalCodeSystem">A code identifying the system under which the hospital code was allocated</param>
        public Demographic(string familyName, string givenName, DateTime dateOfBirth, SexEnumerator sex, string medicareNumber, string medicareIrn, string hospitalCode, string hospitalCodeSystem)
            : base(hospitalCode, hospitalCodeSystem)
        {
            //this.ihi = ihi;
            //this.ihiStatus = ihiStatus;
            //this.ihiRecordStatus = ihiRecordStatus;
            //this.ihiLastValidated = ihiLastValidated;
            this.familyName = familyName;
            this.givenName = givenName;
            this.dateOfBirth = dateOfBirth;
            this.sex = sex;
            this.medicareNumber = medicareNumber;
            this.medicareIrn = medicareIrn;
        }

        public Demographic(string familyName, string givenName, DateTime dateOfBirth, SexEnumerator sex, string dvaNumber, string hospitalCode, string hospitalCodeSystem)
            : base(hospitalCode, hospitalCodeSystem)
        {
            //this.ihi = ihi;
            //this.ihiStatus = ihiStatus;
            //this.ihiRecordStatus = ihiRecordStatus;
            //this.ihiLastValidated = ihiLastValidated;
            this.familyName = familyName;
            this.givenName = givenName;
            this.dateOfBirth = dateOfBirth;
            this.sex = sex;
            this.dvaNumber = dvaNumber;
        }

        #endregion Methods
    }
}