﻿using System.Runtime.Serialization;

namespace HIPS.CommonSchemas.PatientIdentifier
{
    /// <summary>
    /// This abstract class is used for the Patient Identifier classes.
    /// </summary>

    [DataContract]
    [KnownType(typeof(Mrn))]
    [KnownType(typeof(PatientMasterId))]
    [KnownType(typeof(StatePatientId))]
    [KnownType(typeof(ValidatedIhi))]
    [KnownType(typeof(Demographic))]
    abstract public class PatientIdentifierBase
    {
        #region Private Members

        private string hospitalCode;
        private string hospitalCodeSystem;
        private string alternateOrganisationName;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the hospital code. This code, qualified by the hospital code system,
        /// is used to determine:
        /// a) Which hospital allocated the MRN, if the Mrn subclass is used.
        /// b) Which hospital the episode occurred in, for consent, upload and remove calls.
        /// c) Which authorised employee is identified, if the user.Role is AuthorisedEmployee.
        /// d) Which health provider organisation (HPI-O) is making the calls to HI Service and PCEHR B2B Gateway.
        /// </summary>
        /// <value>
        /// A code identifying the hospital in which this patient received health care.
        /// </value>
        [DataMember]
        public string HospitalCode
        {
            get { return hospitalCode; }
            set { hospitalCode = value; }
        }

        /// <summary>
        /// Gets or sets the hospital code system.
        /// This is necessary because different systems may use different codes to identify the
        /// same hospital. For example, "NOA" or "NHS" for Noarlunga Health Service, where
        /// "NOA" is the LAB Facility Code and "NHS" is the PAS Facility Code.
        /// </summary>
        /// <value>
        /// A code identifying the system under which the hospital code was allocated.
        /// </value>
        [DataMember]
        public string HospitalCodeSystem
        {
            get { return hospitalCodeSystem; }
            set { hospitalCodeSystem = value; }
        }

        /// <summary>
        /// Gets or sets the alternate organisation name.
        /// As defined in "PCEHR R12 Implementation Guide", the accessing organisation
        /// may choose to disclose a different organisation name on the PCEHR Audit Log
        /// by populating the alternateOrganisationName in the PCEHR header.
        /// </summary>
        /// <value>
        /// The alternate organisation name.
        /// </value>
        [DataMember]
        public string AlternateOrganisationName
        {
            get { return alternateOrganisationName; }
            set { alternateOrganisationName = value; }
        }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Specific constructor for the abstract base class PatientIdentifierBase.
        /// </summary>
        /// <param name="hospitalCode">The hospital code</param>
        /// <param name="hospitalCodeSystem">The hospital code system</param>
        public PatientIdentifierBase(string hospitalCode, string hospitalCodeSystem)
        {
            this.hospitalCode = hospitalCode;
            this.hospitalCodeSystem = hospitalCodeSystem;
        }

        #endregion Constructors
    }
}