﻿using System.Runtime.Serialization;

namespace HIPS.CommonSchemas.PatientIdentifier
{
    /// <summary>
    /// This Patient Identifier is used for the Identity Column on the PatientMaster Table
    /// </summary>

    [DataContract]
    public class PatientMasterId : PatientIdentifierBase
    {
        #region Private Members

        private int patientMasterId;
        private int? hospitalId;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or Sets the PatientMasterId
        /// </summary>
        /// <value>
        /// Value
        /// </value>
        [DataMember]
        public int Value
        {
            get
            {
                return patientMasterId;
            }
            set
            {
                patientMasterId = value;
            }
        }

        /// <summary>
        /// Gets or Sets the HospitalId
        /// </summary>
        /// <value>
        /// Value
        /// </value>
        [DataMember]
        public int? HospitalId
        {
            get
            {
                return hospitalId;
            }
            set
            {
                hospitalId = value;
            }
        }

        #endregion Properties

        #region Methods

        /// <summary>
        /// Specific constructor for the patient master identifier.
        /// </summary>
        /// <param name="patientMasterId">The patient master identifier</param>
        /// <param name="hospitalCode">The hospital code</param>
        /// <param name="hospitalCodeSystem">The hospital code system</param>
        public PatientMasterId(int patientMasterId, string hospitalCode, string hospitalCodeSystem, int? hospitalId = -1)
            : base(hospitalCode, hospitalCodeSystem)
        {
            this.patientMasterId = patientMasterId;
            this.hospitalId = hospitalId;
        }

        public override string ToString()
        {
            return string.Format("PatientMasterId: {0}", patientMasterId);
        }

        #endregion Methods
    }
}