﻿namespace HIPS.HibIntegration.Enumerators
{
    /// <summary>
    /// This enumeration lists the subset of SA Health Patient Identifier Type codes that are used by HIPS.
    ///
    /// Source: SA Health Standard Enterprise Code Table Specification
    ///         version 3.0e dated 21/11/2012.
    /// </summary>
    public enum IdentifierTypeCode
    {
        MR,   // Medical Record Number
        MC,   // Medicare Card Number (with IRN as 11th digit where available)
        DVA,  // Department of Veterans' Affairs (DVA) File Number
        SAUHI // South Australian Unique Healthcare Identifier
    }
}