﻿// -----------------------------------------------------------------------
// <copyright file="Participant.cs"  company="NEHTA">
// Developed by Chamonix for NEHTA.
// </copyright>
// -----------------------------------------------------------------------

namespace HIPS.HibIntegration.Loader
{
    /// <summary>
    /// Handles padding of MRNs.
    /// </summary>
    public static class MrnPadding
    {
        private const int MRN_PADDING_LENGTH = 9;
        private const char MRN_PADDING_CHARACTER = '0';

        /// <summary>
        /// Adds zeros to the left of the MRN to make it the standard length.
        /// </summary>
        /// <param name="mrn">The incoming MRN.</param>
        /// <returns>The padded MRN.</returns>
        public static string Pad(string mrn)
        {
            return mrn.PadLeft(MRN_PADDING_LENGTH, MRN_PADDING_CHARACTER);
        }
    }
}