﻿using System;
using System.Runtime.Serialization;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This class is used for Australian Address structures
    /// </summary>

    [KnownType(typeof(AustralianAddress))]
    [Serializable]
    [DataContract]
    public class AustralianAddress
    {
        #region Private Members

        private UnitType? unitType;
        private string unitNumber;
        private string siteName;
        private LevelType? levelType;
        private string levelNumber;
        private string streetNumber;
        private string lotNumber;
        private string streetName;
        private StreetType? streetType;
        private StreetSuffixType? streetSuffixType;
        private PostalDeliveryType? postalDeliveryType;
        private string postalDeliveryNumber;
        private string suburb;
        private StateType? state;
        private string postCode;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or Sets the UnitType
        /// </summary>
        /// <value>
        /// The unitType
        /// </value>
        [DataMember]
        public UnitType? UnitType
        {
            get { return unitType; }
            set { unitType = value; }
        }

        /// <summary>
        /// Gets or Sets the UnitNumber
        /// </summary>
        /// <value>
        /// The unitNumber
        /// </value>
        [DataMember]
        public string UnitNumber
        {
            get { return unitNumber; }
            set { unitNumber = value; }
        }

        /// <summary>
        /// Gets or Sets the SiteName
        /// </summary>
        /// <value>
        /// The siteName
        /// </value>
        [DataMember]
        public string SiteName
        {
            get { return siteName; }
            set { siteName = value; }
        }

        /// <summary>
        /// Gets or Sets the LevelType
        /// </summary>
        /// <value>
        /// The levelType
        /// </value>
        [DataMember]
        public LevelType? LevelType
        {
            get { return levelType; }
            set { levelType = value; }
        }

        /// <summary>
        /// Gets or Sets the LevelNumber
        /// </summary>
        /// <value>
        /// The levelNumber
        /// </value>
        public string LevelNumber
        {
            get { return levelNumber; }
            set { levelNumber = value; }
        }

        /// <summary>
        /// Gets or Sets the StreetNumber
        /// </summary>
        /// <value>
        /// The streetNumber
        /// </value>
        [DataMember]
        public string StreetNumber
        {
            get { return streetNumber; }
            set { streetNumber = value; }
        }

        /// <summary>
        /// Gets or Sets the LotNumber
        /// </summary>
        /// <value>
        /// The lotNumber
        /// </value>
        [DataMember]
        public string LotNumber
        {
            get { return lotNumber; }
            set { lotNumber = value; }
        }

        /// <summary>
        /// Gets or Sets the StreetName
        /// </summary>
        /// <value>
        /// The streetName
        /// </value>
        [DataMember]
        public string StreetName
        {
            get { return streetName; }
            set { streetName = value; }
        }

        /// <summary>
        /// Gets or Sets the StreetType
        /// </summary>
        /// <value>
        /// The streetType
        /// </value>
        [DataMember]
        public StreetType? StreetType
        {
            get { return streetType; }
            set { streetType = value; }
        }

        /// <summary>
        /// Gets or Sets the StreetSuffixType
        /// </summary>
        /// <value>
        /// The streetSuffixType
        /// </value>
        [DataMember]
        public StreetSuffixType? StreetSuffixType
        {
            get { return streetSuffixType; }
            set { streetSuffixType = value; }
        }

        /// <summary>
        /// Gets or Sets the PostalDeliveryType
        /// </summary>
        /// <value>
        /// The postalDeliveryType
        /// </value>
        [DataMember]
        public PostalDeliveryType? PostalDeliveryType
        {
            get { return postalDeliveryType; }
            set { postalDeliveryType = value; }
        }

        /// <summary>
        /// Gets or Sets the PostalDeliveryNumber
        /// </summary>
        /// <value>
        /// The postalDeliveryNumber
        /// </value>
        [DataMember]
        public string PostalDeliveryNumber
        {
            get { return postalDeliveryNumber; }
            set { postalDeliveryNumber = value; }
        }

        /// <summary>
        /// Gets or Sets the Suburb
        /// </summary>
        /// <value>
        /// The suburb
        /// </value>
        [DataMember]
        public string Suburb
        {
            get { return suburb; }
            set { suburb = value; }
        }

        /// <summary>
        /// Gets or Sets the State
        /// </summary>
        /// <value>
        /// The state
        /// </value>
        [DataMember]
        public StateType? State
        {
            get { return state; }
            set { state = value; }
        }

        /// <summary>
        /// Gets or Sets the PostCode
        /// </summary>
        /// <value>
        /// The postCode
        /// </value>
        [DataMember]
        public string PostCode
        {
            get { return postCode; }
            set { postCode = value; }
        }

        #endregion Properties
    }
}