﻿using System;
using System.Runtime.Serialization;

namespace HIPS.HpiiSchemas.Enumerators
{
    /// <summary>
    /// Status used for the mapping of the returned type from the HPII status.
    /// </summary>
    [Serializable]
    [DataContract]
    public enum HpiiStatus
    {
        ///// <summary>
        ///// Undefined, this is the default value if the enum is left unset.
        /////
        ///// The validation engine uses this to test and assert that the enum has been set (if required)
        ///// and is therefore valid.
        ///// </summary>
        [EnumMember]
        Undefined = -1,

        /// <summary>
        /// Active HpiiStatus Record
        /// </summary>
        [EnumMember]
        Active = 1,

        /// <summary>
        /// DeactivatedHpiiStatus Record
        /// </summary>
        [EnumMember]
        Deactivated = 2,

        /// <summary>
        /// Retired HpiiStatus Record
        /// </summary>
        [EnumMember]
        Retired = 3
    }
}