﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This class is used for the Batch Asynchronous Retrieval Request of the HPI-I Queries for identifier and demographic searches
    /// </summary>

    [KnownType(typeof(HpiiBatchAsyncRetrieveResponse))]
    [Serializable]
    [DataContract]
    public class HpiiBatchAsyncRetrieveResponse
    {
        #region Private Members

        private string batchIdentifier;
        private ServiceMessagesType serviceMessagesType;
        private IList<HpiiBatchQueryResponse> hpiiBatchQueryResponses;
        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or Sets the BatchIdentifier
        /// </summary>
        /// <value>
        /// The batchIdentifier
        /// </value>
        [DataMember]
        public string BatchIdentifier
        {
            get { return batchIdentifier; }
            set { batchIdentifier = value; }
        }

        /// <summary>
        /// Gets or Sets the ServiceMessagesType
        /// </summary>
        /// <value>
        /// The serviceMessagesType
        /// </value>
        [DataMember]
        public ServiceMessagesType ServiceMessagesType
        {
            get { return serviceMessagesType; }
            set { serviceMessagesType = value; }
        }

        /// <summary>
        /// Gets or Sets the MyProperty
        /// </summary>
        /// <value>
        /// The <HpiiBatchQueryResponse> HpiiBatchQueryResponses
        /// </value>
        [DataMember]
        public IList<HpiiBatchQueryResponse> HpiiBatchQueryResponses
        {
            get { return hpiiBatchQueryResponses; }
            set { hpiiBatchQueryResponses = value; }
        }

        /// <summary>
        /// Gets or Sets the ServiceMessagesType
        /// </summary>
        /// <value>
        /// The serviceMessagesType
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        #endregion Properties
    }
}