﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This class is used for the Batch Asynchronous Submitting Request of the HPI-I Queries for identifier and demographic searches
    /// </summary>

    [KnownType(typeof(HpiiBatchAsyncSubmitRequest))]
    [KnownType(typeof(HpiiIdentifierQuery))]
    [KnownType(typeof(HpiiDemographicQuery))]
    [KnownType(typeof(HpiiQuery))]
    [Serializable]
    [DataContract]
    public class HpiiBatchAsyncSubmitRequest
    {
        #region Private Members

        private string hpioNumber;
        private IList<HpiiIdentifierQuery> hpiiIdentifierQueries;
        private IList<HpiiDemographicQuery> hpiiDemographicQueries;

        #endregion Private Members

        #region Methods

        /// <summary>
        /// Constructor to initialise Lists
        /// </summary>
        public HpiiBatchAsyncSubmitRequest()
        {
            hpiiIdentifierQueries = new List<HpiiIdentifierQuery>();
            hpiiDemographicQueries = new List<HpiiDemographicQuery>();
        }

        #endregion Methods

        #region Properties

        /// <summary>
        /// Gets or Sets the HpioNumber - This is an over arching HPIO which will be used for all queries in the batch
        /// </summary>
        /// <value>
        /// The hpioNumber
        /// </value>
        [DataMember]
        public string HpioNumber
        {
            get { return hpioNumber; }
            set { hpioNumber = value; }
        }

        /// <summary>
        /// Gets or Sets the HpiiIdentifierQueries
        /// </summary>
        /// <value>
        /// The hpiiIdentifierQueries
        /// </value>
        [DataMember]
        public IList<HpiiIdentifierQuery> HpiiIdentifierQueries
        {
            get { return hpiiIdentifierQueries; }
            set { hpiiIdentifierQueries = value; }
        }

        /// <summary>
        /// Gets or Sets the HpiiDemographicQueries
        /// </summary>
        /// <value>
        /// The hpiiDemographicQueries
        /// </value>
        [DataMember]
        public IList<HpiiDemographicQuery> HpiiDemographicQueries
        {
            get { return hpiiDemographicQueries; }
            set { hpiiDemographicQueries = value; }
        }

        #endregion Properties
    }
}