﻿using System;
using System.Runtime.Serialization;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This object is used for HPI-I Queries for a single identification query
    /// </summary>
    [KnownType(typeof(HpiiQuery))]
    [KnownType(typeof(HpiiIdentifierQuery))]
    [Serializable]
    [DataContract]
    public class HpiiIdentifierQuery : HpiiQuery
    {
        #region Private Members

        private string hpiiNumber;
        private string registrationId;
        private StateType? state;
        private string postCode;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or Sets the HpiiNumber
        /// </summary>
        /// <value>
        /// The hpiiNumber
        /// </value>
        [DataMember]
        public string HpiiNumber
        {
            get { return hpiiNumber; }
            set { hpiiNumber = value; }
        }

        /// <summary>
        /// Gets or Sets the RegistrationId
        /// </summary>
        /// <value>
        /// The registrationId
        /// </value>
        [DataMember]
        public string RegistrationId
        {
            get { return registrationId; }
            set { registrationId = value; }
        }

        /// <summary>
        /// Gets or Sets the State
        /// </summary>
        /// <value>
        /// The state
        /// </value>
        [DataMember]
        public StateType? State
        {
            get { return state; }
            set { state = value; }
        }

        /// <summary>
        /// Gets or Sets the PostCode
        /// </summary>
        /// <value>
        /// The postCode
        /// </value>
        [DataMember]
        public string PostCode
        {
            get { return postCode; }
            set { postCode = value; }
        }

        #endregion Properties
    }
}