﻿using System;
using System.Runtime.Serialization;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This abtract class is used for the base of the HPI-I Queries for identifier and demographic searches
    /// </summary>

    [KnownType(typeof(HpiiQuery))]
    [Serializable]
    [DataContract]
    public abstract class HpiiQuery
    {
        #region Private Members

        private string hpioNumber;
        private string familyName;
        private string[] givenName;
        private DateTime? dateOfBirth;
        private SexType? sex;
        private bool onlyNameIndicator;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or Sets the HpioNumber
        /// </summary>
        /// <value>
        /// The hpioNumber
        /// </value>
        [DataMember]
        public string HpioNumber
        {
            get { return hpioNumber; }
            set { hpioNumber = value; }
        }

        /// <summary>
        /// Gets or Sets the FamilyName
        /// </summary>
        /// <value>
        /// The familyName
        /// </value>
        [DataMember]
        public string FamilyName
        {
            get { return familyName; }
            set { familyName = value; }
        }

        /// <summary>
        /// Gets or Sets the GivenName
        /// </summary>
        /// <value>
        /// The givenName
        /// </value>
        [DataMember]
        public string[] GivenName
        {
            get { return givenName; }
            set { givenName = value; }
        }

        /// <summary>
        /// Gets or Sets the DateofBirth
        /// </summary>
        /// <value>
        /// The dateOfBirth
        /// </value>
        [DataMember]
        public DateTime? DateofBirth
        {
            get { return dateOfBirth; }
            set { dateOfBirth = value; }
        }

        /// <summary>
        /// Gets or Sets the Sex (Gender)
        /// </summary>
        /// <value>
        /// The sex of the individual
        /// </value>
        [DataMember]
        public SexType? Sex
        {
            get { return sex; }
            set { sex = value; }
        }

        /// <summary>
        /// Gets or Sets the OnlyNameIndicator
        /// </summary>
        /// <value>
        /// The onlyNameIndicator
        /// </value>
        [DataMember]
        public bool OnlyNameIndicator
        {
            get { return onlyNameIndicator; }
            set { onlyNameIndicator = value; }
        }

        #endregion Properties

        #region Methods

        #endregion Methods
    }
}