﻿using System;
using System.Runtime.Serialization;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This class is used for the International Address Structure
    /// </summary>

    [KnownType(typeof(InternationalAddress))]
    [Serializable]
    [DataContract]
    public class InternationalAddress
    {
        #region Private Members

        private string internationalAddressLine;
        private string internationalStateProvince;
        private string internationalPostcode;
        private CountryType? country;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or Sets the InternationalAddressLine
        /// </summary>
        /// <value>
        /// The internationalAddressLine
        /// </value>
        [DataMember]
        public string InternationalAddressLine
        {
            get { return internationalAddressLine; }
            set { internationalAddressLine = value; }
        }

        /// <summary>
        /// Gets or Sets the InternationalStateProvince
        /// </summary>
        /// <value>
        /// The internationalStateProvince
        /// </value>
        [DataMember]
        public string InternationalStateProvince
        {
            get { return internationalStateProvince; }
            set { internationalStateProvince = value; }
        }

        /// <summary>
        /// Gets or Sets the InternationalPostcode
        /// </summary>
        /// <value>
        /// The internationalPostcode
        /// </value>
        [DataMember]
        public string InternationalPostcode
        {
            get { return internationalPostcode; }
            set { internationalPostcode = value; }
        }

        /// <summary>
        /// Gets or Sets the Country
        /// </summary>
        /// <value>
        /// The country
        /// </value>
        [DataMember]
        public CountryType? Country
        {
            get { return country; }
            set { country = value; }
        }

        #endregion Properties
    }
}