﻿namespace HIPS.IhiSchemas.Schemas
{
    public enum Gender
    {
        Female = 2,
        Male = 1,
        Indeterminate = 4,
        NotSpecified = -1
    };

    /// <summary>
    /// The type of name search that is being used to lookup an IHI
    /// </summary>
    public enum IhiNameSearchType
    {
        Registered,
        Current
    };

    public enum IhiLookupReturnStatus
    {
        /// <summary>
        /// The request executed correctly
        /// </summary>
        OK = 0,

        /// <summary>
        /// The patient was not found with the specified search data
        /// </summary>
        InvalidPatient = 1,

        /// <summary>
        /// The user details were not valid
        /// </summary>
        InvalidUser = 2,

        /// <summary>
        /// The HI Service returned an error
        /// </summary>
        ServiceError = 9,

        /// <summary>
        /// The application failed. Details recorded within the application database.
        /// </summary>
        SystemError = 99
    }
}