﻿using System;
using System.Runtime.Serialization;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using nehta.mcaR3.ConsumerSearchIHI;
using Nehta.VendorLibrary.Common;

namespace HIPS.IhiSchemas.Schemas
{
    /// <summary>
    /// Class that encapsulates the searchIHIResponse object for return
    /// </summary>
    [KnownType(typeof(HipsIhiResponse))]
    [Serializable]
    [DataContract]
    public class HipsIhiResponse
    {
        #region Private Members

        private searchIHIResponse searchIHIResponse;
        private string returnMessage;
        private string ihiNumber;
        private bool? pcehrExists = null;
        private IhiStatus returnedIhiStatus = IhiStatus.Unknown;
        private IhiRecordStatus returnedIhiRecordStatus = IhiRecordStatus.Unknown;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the search IHI response.
        /// </summary>
        /// <value>
        /// The search IHI response.
        /// </value>
        [DataMember]
        public searchIHIResponse SearchIHIResponse
        {
            get { return searchIHIResponse; }
            set { searchIHIResponse = value; }
        }

        /// <summary>
        /// Gets or sets the return message.
        /// </summary>
        /// <value>
        /// The return message.
        /// </value>
        [DataMember]
        public string ReturnMessage
        {
            get { return returnMessage; }
            set { returnMessage = value; }
        }

        /// <summary>
        /// Gets or sets the IHI number.
        /// </summary>
        /// <value>
        /// The IHI number.
        /// </value>
        [DataMember]
        public string IhiNumber
        {
            get { return ihiNumber; }
            set
            {
                if (value != null && value.StartsWith(HIQualifiers.IHIQualifier))
                {
                    value = value.Substring(HIQualifiers.IHIQualifier.Length);
                }

                ihiNumber = value;
            }
        }

        /// <summary>
        /// Gets or sets the pcehr exists.
        /// </summary>
        /// <value>
        /// The pcehr exists.
        /// </value>
        [DataMember]
        public bool? PcehrExists
        {
            get { return pcehrExists; }
            set { pcehrExists = value; }
        }

        /// <summary>
        /// Gets or sets the returned IHI status.
        /// </summary>
        /// <value>
        /// The returned IHI status.
        /// </value>
        [DataMember]
        public IhiStatus ReturnedIhiStatus
        {
            get
            {
                return returnedIhiStatus;
            }
            set
            {
                returnedIhiStatus = value;
            }
        }

        /// <summary>
        /// Gets or sets the returned ihi record status.
        /// </summary>
        /// <value>
        /// The returned ihi record status.
        /// </value>
        [DataMember]
        public IhiRecordStatus ReturnedIhiRecordStatus
        {
            get
            {
                return returnedIhiRecordStatus;
            }
            set
            {
                returnedIhiRecordStatus = value;
            }
        }

        #endregion Properties
    }
}