﻿using System;
using System.Runtime.Serialization;
using HIPS.ConsentSchemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PatientSchemas
{
    /// <summary>
    /// Represents a patient in hospital.
    /// </summary>
    [DataContract]
    public class PatientInHospital
    {
        /// <summary>
        /// The patient's IHI.
        /// </summary>
        [DataMember]
        public string Ihi { get; set; }

        /// <summary>
        /// The patient's IHI status.
        /// </summary>
        [DataMember]
        public IhiStatus IhiStatus { get; set; }

        /// <summary>
        /// The patient's IHI record status.
        /// </summary>
        [DataMember]
        public IhiRecordStatus IhiRecordStatus { get; set; }

        /// <summary>
        /// The patient's IHI last validated date.
        /// </summary>
        [DataMember]
        public DateTime? IhiLastValidated { get; set; }

        /// <summary>
        /// The patient's Date of Birth.
        /// </summary>
        [DataMember]
        public DateTime DateOfBirth { get; set; }

        /// <summary>
        /// The patient's Medicare Number.
        /// </summary>
        [DataMember]
        public string MedicareNumber { get; set; }

        /// <summary>
        /// The patient's Medicare Individual Reference Number (IRN).
        /// </summary>
        [DataMember]
        public string MedicareIrn { get; set; }

        /// <summary>
        /// The patient's DVA Number.
        /// </summary>
        [DataMember]
        public string DvaNumber { get; set; }

        /// <summary>
        /// The patient's current sex identifier.
        /// </summary>
        public int CurrentSexId { get; set; }

        /// <summary>
        /// The patient's current sex.
        /// </summary>
        [DataMember]
        public SexEnumerator CurrentSex { get; set; }

        /// <summary>
        /// The patient's family name.
        /// </summary>
        [DataMember]
        public string FamilyName { get; set; }

        /// <summary>
        /// The patient's given names.
        /// </summary>
        [DataMember]
        public string GivenNames { get; set; }

        /// <summary>
        /// The patient's current sex.
        /// </summary>
        [DataMember]
        public SexEnumerator RegisteredSex { get; set; }

        /// <summary>
        /// The patient's Medicare registered family name.
        /// </summary>
        [DataMember]
        public string RegisteredFamilyName { get; set; }

        /// <summary>
        /// The patient's Medicare registered given name.
        /// </summary>
        [DataMember]
        public string RegisteredGivenName { get; set; }

        /// <summary>
        /// The patient's name suffixes (like "Jr")
        /// </summary>
        [DataMember]
        public string Suffix { get; set; }

        /// <summary>
        /// The patient's titles (like "Dr", "Ms" or "Mr")
        /// </summary>
        [DataMember]
        public string Title { get; set; }

        /// <summary>
        /// The internal primary key of the hospital where the patient is or was admitted.
        /// </summary>
        public int HospitalId { get; set; }

        /// <summary>
        /// The code of the hospital where the patient is or was admitted.
        /// </summary>
        [DataMember]
        public string HospitalCode { get; set; }

        /// <summary>
        /// The name of the hospital where the patient is or was admitted.
        /// </summary>
        [DataMember]
        public string HospitalName { get; set; }

        /// <summary>
        /// The patient's MRN at the hospital where the patient was admitted.
        /// </summary>
        [DataMember]
        public string Mrn { get; set; }

        /// <summary>
        /// The current Ward of the patient.
        /// </summary>
        [DataMember]
        public string Ward { get; set; }

        /// <summary>
        /// The current Room of the patient.
        /// </summary>
        [DataMember]
        public string Room { get; set; }

        /// <summary>
        /// The current Bed of the patient.
        /// </summary>
        [DataMember]
        public string Bed { get; set; }

        /// <summary>
        /// The admission date of the patient.
        /// </summary>
        [DataMember]
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// The discharge date of the patient.
        /// </summary>
        [DataMember]
        public DateTime? DischargeDate { get; set; }

        /// <summary>
        /// The family name of the patient's responsible provider.
        /// </summary>
        [DataMember]
        public string ResponsibleProviderFamilyName { get; set; }

        /// <summary>
        /// The given names of the patient's responsible provider.
        /// </summary>
        [DataMember]
        public string ResponsibleProviderGivenNames { get; set; }

        /// <summary>
        /// The title of the patient's responsible provider (such as 'Dr', 'Ms' or 'Mr').
        /// </summary>
        [DataMember]
        public string ResponsibleProviderTitle { get; set; }

        /// <summary>
        /// The suffix of the patient's responsible provider (such as 'Jr' or 'Sr')
        /// </summary>
        [DataMember]
        public string ResponsibleProviderSuffix { get; set; }

        /// <summary>
        /// The patient's PCEHR participation status.
        /// </summary>
        [DataMember]
        public ParticipationStatus ParticipationStatus { get; set; }
    }
}
